/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMediaFilesFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaFileTypeContainer> {
    public TvShowMediaFilesFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MediaFileTypeContainer> mediaFileTypeList = new ArrayList<MediaFileTypeContainer>();
        block3: for (MediaFileType type : MediaFileType.values()) {
            switch (type) {
                case VIDEO_EXTRA: 
                case GRAPHIC: 
                case DOUBLE_EXT: {
                    continue block3;
                }
                default: {
                    mediaFileTypeList.add(new MediaFileTypeContainer(type));
                }
            }
        }
        this.setValues(mediaFileTypeList);
    }

    @Override
    protected String parseTypeToString(MediaFileTypeContainer container) throws Exception {
        return container.type.name();
    }

    @Override
    protected MediaFileTypeContainer parseStringToType(String string) throws Exception {
        return new MediaFileTypeContainer(MediaFileType.valueOf(string));
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        boolean isValid = false;
        ArrayList<MediaFileType> selectedItems = new ArrayList<MediaFileType>();
        for (MediaFileTypeContainer container : this.checkComboBox.getSelectedItems()) {
            selectedItems.add(container.type);
        }
        for (TvShowEpisode episode : episodes) {
            boolean foundEpisode = false;
            List<MediaFile> mfs = episode.getMediaFiles();
            for (MediaFile mf : mfs) {
                if (!selectedItems.contains((Object)mf.getType())) continue;
                foundEpisode = true;
                break;
            }
            for (MediaFile mf : episode.getTvShowSeason().getMediaFiles()) {
                if (!selectedItems.contains((Object)mf.getType())) continue;
                foundEpisode = true;
                break;
            }
            if (invert && !foundEpisode) {
                return true;
            }
            if (invert || !foundEpisode) continue;
            return true;
        }
        boolean foundShow = false;
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!selectedItems.contains((Object)mf.getType())) continue;
            foundShow = true;
            break;
        }
        if (!invert && foundShow) {
            return true;
        }
        if (invert && foundShow) {
            return false;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.mediatype"));
    }

    @Override
    public String getId() {
        return "tvShowMediaFiles";
    }

    public static class MediaFileTypeContainer {
        private final MediaFileType type;

        public MediaFileTypeContainer(MediaFileType type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaFileTypeContainer that = (MediaFileTypeContainer)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public String toString() {
            try {
                return TmmResourceBundle.getString("mediafiletype." + this.type.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception e) {
                return this.type.toString();
            }
        }
    }
}

