/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Taskbar;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmTaskbar;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.dialogs.TaskListDialog;
import org.tinymediamanager.ui.panels.MemoryUsagePanel;

public class StatusBarPanel
extends JPanel
implements TmmTaskListener {
    private final Set<TmmTaskHandle> taskSet;
    private TmmTaskHandle activeTask;
    private JPanel memoryUsagePanel;
    private JLabel taskLabel;
    private JProgressBar taskProgressBar;
    private JButton taskStopButton;

    public StatusBarPanel() {
        this.initComponents();
        this.taskLabel.setVisible(false);
        this.taskStopButton.setVisible(false);
        this.taskProgressBar.setVisible(false);
        this.taskSet = new HashSet<TmmTaskHandle>();
        this.taskLabel.setText("");
        TmmTaskManager.getInstance().addTaskListener(this);
        Settings settings = Settings.getInstance();
        this.memoryUsagePanel.setVisible(settings.isShowMemory());
        this.memoryUsagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.gc();
            }
        });
        settings.addPropertyChangeListener(evt -> this.memoryUsagePanel.setVisible(settings.isShowMemory()));
        TaskListDialog.getInstance();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 n 0 0, hidemode 3", "[][50lp:n][grow][100lp][15lp:n][][]", "[22lp:n]"));
        this.taskLabel = new JLabel("XYZ");
        this.add((Component)this.taskLabel, "cell 2 0,alignx right, wmin 0");
        this.taskProgressBar = new JProgressBar();
        this.taskProgressBar.addMouseListener(new MListener());
        this.add((Component)this.taskProgressBar, "cell 3 0");
        this.taskStopButton = new FlatButton(IconManager.CANCEL);
        this.taskStopButton.addActionListener(e -> {
            if (this.activeTask instanceof TmmTask) {
                this.activeTask.cancel();
            }
        });
        this.add((Component)this.taskStopButton, "cell 4 0");
        this.memoryUsagePanel = new MemoryUsagePanel();
        this.add((Component)this.memoryUsagePanel, "cell 6 0");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics2D = (Graphics2D)g.create();
        graphics2D.setColor(UIManager.getColor("Panel.tmmAlternateBackground"));
        graphics2D.drawLine(0, 0, this.getWidth(), 0);
        graphics2D.dispose();
    }

    @Override
    public synchronized void processTaskEvent(TmmTaskHandle task) {
        SwingUtilities.invokeLater(() -> {
            switch (task.getState()) {
                case CREATED: 
                case QUEUED: 
                case STARTED: 
                case CANCELLED: {
                    this.taskSet.add(task);
                    break;
                }
                case FINISHED: 
                case FAILED: {
                    this.taskSet.remove(task);
                }
            }
            if (this.activeTask == null || this.activeTask.getState() == TmmTaskHandle.TaskState.FINISHED || this.activeTask.getState() == TmmTaskHandle.TaskState.FAILED) {
                this.activeTask = null;
                for (TmmTaskHandle handle : this.taskSet) {
                    if (handle.getType() != TmmTaskHandle.TaskType.MAIN_TASK || handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                    this.activeTask = handle;
                    break;
                }
                if (this.activeTask == null) {
                    for (TmmTaskHandle handle : this.taskSet) {
                        if (handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                        this.activeTask = handle;
                        break;
                    }
                }
            }
            if (this.activeTask == null) {
                this.taskLabel.setVisible(false);
                this.taskStopButton.setVisible(false);
                this.taskProgressBar.setVisible(false);
                TmmTaskbar.setProgressState(Taskbar.State.OFF);
                TmmTaskbar.setProgressValue(-1);
            } else {
                this.taskLabel.setVisible(true);
                this.taskProgressBar.setVisible(true);
                if (this.activeTask.getType() == TmmTaskHandle.TaskType.MAIN_TASK) {
                    this.taskStopButton.setVisible(true);
                } else {
                    this.taskStopButton.setVisible(false);
                }
                this.taskLabel.setText(this.activeTask.getTaskName());
                if (this.activeTask.getWorkUnits() > 0) {
                    try {
                        int workUnits = this.activeTask.getWorkUnits();
                        if (workUnits == 1) {
                            this.taskProgressBar.setIndeterminate(true);
                        } else {
                            this.taskProgressBar.setMaximum(workUnits);
                            this.taskProgressBar.setValue(this.activeTask.getProgressDone());
                            this.taskProgressBar.setIndeterminate(false);
                        }
                        TmmTaskbar.setProgressState(Taskbar.State.NORMAL);
                        TmmTaskbar.setProgressValue(100 * this.activeTask.getProgressDone() / this.activeTask.getWorkUnits());
                    }
                    catch (Exception exception) {}
                } else {
                    this.taskProgressBar.setIndeterminate(true);
                    TmmTaskbar.setProgressState(Taskbar.State.INDETERMINATE);
                }
            }
        });
    }

    public static void setOomDetected() {
        MemoryUsagePanel.setOomDetected();
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TaskListDialog.getInstance().setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

