/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetReadMovieNfoAction
extends TmmAction {
    public MovieSetReadMovieNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.readnfo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("movie.readnfo"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (Movie movie : selectedMovies) {
                    Movie tempMovie = null;
                    for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
                        if (tempMovie == null) {
                            try {
                                tempMovie = MovieNfoParser.parseNfo(mf.getFileAsPath()).toMovie();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (tempMovie == null) continue;
                        try {
                            tempMovie.merge(MovieNfoParser.parseNfo(mf.getFileAsPath()).toMovie());
                        }
                        catch (Exception exception) {}
                    }
                    if (tempMovie != null) {
                        movie.forceMerge(tempMovie);
                        movie.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

