/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MessagePanel;

public class MessageHistoryDialog
extends TmmDialog
implements ListEventListener<Message> {
    private static MessageHistoryDialog instance;
    private final Map<Message, JPanel> messageMap;
    private final JPanel messagesPanel;

    private MessageHistoryDialog() {
        super(MainWindow.getInstance(), TmmResourceBundle.getString("summarywindow.title"), "messageSummary");
        this.setModal(false);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.messageMap = new HashMap<Message, JPanel>();
        JPanel panelNorth = new JPanel();
        panelNorth.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[][shrink 0]"));
        this.getContentPane().add((Component)panelNorth, "North");
        panelNorth.add((Component)new TmmLabel("Message history"), "cell 0 0, grow");
        LinkLabel lblClearAll = new LinkLabel("Clear all");
        panelNorth.add((Component)lblClearAll, "cell 1 0");
        panelNorth.add((Component)new JSeparator(), "cell 0 1 2 1, grow");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[150lp:450lp,grow]", "[100lp:400lp,grow]"));
        this.getContentPane().add((Component)panelContent, "Center");
        this.messagesPanel = new JPanel();
        this.messagesPanel.setOpaque(false);
        this.messagesPanel.setLayout((LayoutManager)new MigLayout("wrap", "[grow]", "[]"));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportView(this.messagesPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        panelContent.add((Component)scrollPane, "cell 0 0,grow, wmin 0");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        TmmUIMessageCollector.instance.getMessages().addListEventListener((ListEventListener)this);
        this.updatePanel();
        lblClearAll.addActionListener(arg0 -> {
            this.messageMap.clear();
            this.messagesPanel.removeAll();
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
        });
    }

    public static MessageHistoryDialog getInstance() {
        if (instance == null) {
            instance = new MessageHistoryDialog();
        }
        return instance;
    }

    @Override
    public void setVisible(boolean visible) {
        TmmUIMessageCollector.instance.resetNewMessageCount();
        super.setVisible(visible);
    }

    public void listChanged(ListEvent<Message> listChanges) {
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePanel() {
        EventList<Message> list = TmmUIMessageCollector.instance.getMessages();
        list.getReadWriteLock().readLock().lock();
        try {
            for (Message message : list) {
                if (this.messageMap.containsKey(message)) continue;
                MessagePanel panel = new MessagePanel(message);
                this.messageMap.put(message, panel);
                this.messagesPanel.add((Component)panel, "grow");
            }
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
        }
        finally {
            list.getReadWriteLock().readLock().unlock();
        }
    }
}

