/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.panel;

import java.awt.FlowLayout;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;

public class IdLinkPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdLinkPanel.class);

    public IdLinkPanel(String key, MediaEntity mediaEntity) {
        JLabel idLabel;
        this.setLayout(new FlowLayout(0, 0, 0));
        TmmLabel keyLabel = new TmmLabel(this.createTextForKey(key));
        keyLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 5));
        String id = mediaEntity.getIdAsString(key);
        String url = this.createUrlForId(key, id, mediaEntity);
        if (url.startsWith("http")) {
            LinkLabel linkLabel = new LinkLabel(id);
            linkLabel.setLink(url);
            linkLabel.addActionListener(arg0 -> {
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e) {
                    LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)e.getMessage());
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            });
            idLabel = linkLabel;
        } else {
            idLabel = new JLabel(id);
        }
        idLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.add(keyLabel);
        this.add(idLabel);
    }

    private String createTextForKey(String key) {
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "imdb" -> "IMDb:";
            case "tmdb" -> "TMDB:";
            case "wikidata" -> "Wikidata:";
            case "trakt" -> "Trakt.tv:";
            case "tmdbset" -> "TMDB " + TmmResourceBundle.getString("metatag.movieset") + ":";
            default -> key + ":";
        };
    }

    private String createUrlForId(String key, String id, MediaEntity mediaEntity) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        Object url = "";
        switch (key) {
            case "imdb": {
                url = "https://www.imdb.com/title/" + id;
                break;
            }
            case "moviemeter": {
                url = "https://www.moviemeter.nl/film/" + id;
                break;
            }
            case "mpdbtv": {
                url = "https://mpdb.tv/movie/en_us/" + id;
                break;
            }
            case "ofdb": {
                url = "https://ssl.ofdb.de/film/" + id + "," + mediaEntity.getTitle();
                break;
            }
            case "omdbapi": {
                url = "https://www.omdb.org/movie/" + id + "-" + mediaEntity.getTitle();
                break;
            }
            case "wikidata": {
                url = "https://www.wikidata.org/wiki/" + id;
                break;
            }
            case "eidr": {
                url = "https://ui.eidr.org/view/content?id=" + id;
                break;
            }
            case "tmdbSet": {
                url = "https://www.themoviedb.org/collection/" + id;
                break;
            }
            case "anidb": {
                url = "https://anidb.net/anime/" + id;
                break;
            }
            case "myanimelist": {
                url = "https://myanimelist.net/anime/" + id;
                break;
            }
            case "animeplanet": {
                url = "https://www.anime-planet.com/anime/" + id;
                break;
            }
            case "anilist": {
                url = "https://anilist.co/anime/" + id;
                break;
            }
            case "livechart": {
                url = "https://www.livechart.me/anime/" + id;
                break;
            }
            case "animecountdown": {
                url = "https://animecountdown.com/" + id;
                break;
            }
            case "anisearch": {
                url = "https://www.anisearch.com/anime/" + id;
                break;
            }
            case "animenewsnetwork": {
                url = "https://www.animenewsnetwork.com/encyclopedia/anime.php?id=" + id;
                break;
            }
            case "kitsu": {
                url = "https://kitsu.app/anime/" + id;
                break;
            }
            case "notify": {
                url = "https://notify.moe/anime/" + id;
                break;
            }
        }
        if (mediaEntity instanceof Movie) {
            switch (key) {
                case "trakt": {
                    url = "https://trakt.tv/search/trakt/" + id + "?id_type=movie";
                    break;
                }
                case "tmdb": {
                    url = "https://www.themoviedb.org/movie/" + id;
                    break;
                }
                case "tvdb": {
                    url = "https://thetvdb.com/dereferrer/movie/" + id;
                    break;
                }
                case "simkl": {
                    url = "https://simkl.com/movies/" + id;
                    break;
                }
            }
        } else if (mediaEntity instanceof TvShow) {
            switch (key) {
                case "trakt": {
                    url = "https://trakt.tv/search/trakt/" + id + "?id_type=show";
                    break;
                }
                case "tmdb": {
                    url = "https://www.themoviedb.org/tv/" + id;
                    break;
                }
                case "tvdb": {
                    url = "https://thetvdb.com/dereferrer/series/" + id;
                    break;
                }
                case "tvmaze": {
                    url = "https://www.tvmaze.com/shows/" + id;
                    break;
                }
                case "tsdb": {
                    url = "https://www.thesportsdb.com/league/" + id;
                    break;
                }
                case "simkl": {
                    url = "https://simkl.com/tv/" + id;
                    break;
                }
            }
        } else if (mediaEntity instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)mediaEntity;
            switch (key) {
                case "trakt": {
                    url = "https://trakt.tv/search/trakt/" + id + "?id_type=episode";
                    break;
                }
                case "tmdb": {
                    try {
                        int tvShowId = episode.getTvShow().getTmdbId();
                        int seasonId = episode.getAiredSeason();
                        int episodeId = episode.getAiredEpisode();
                        url = "https://www.themoviedb.org/tv/" + tvShowId + "/season/" + seasonId + "/episode/" + episodeId;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case "tvdb": {
                    url = "https://thetvdb.com/dereferrer/episode/" + id;
                    break;
                }
                case "tvmaze": {
                    url = "https://www.tvmaze.com/episodes/" + id;
                    break;
                }
                case "tsdb": {
                    url = "https://www.thesportsdb.com/event/" + id;
                    break;
                }
                case "anidb": {
                    url = "https://anidb.net/episode/" + id;
                    break;
                }
            }
        }
        return url;
    }
}

