/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;

public class TvShowSyncTraktTvTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSyncTraktTvTask.class);
    private final List<TvShow> tvShows = new ArrayList<TvShow>();
    private boolean syncCollection = false;
    private boolean syncWatched = false;
    private boolean syncRating = false;
    private boolean removeFromCollection = false;
    private boolean removeFromWatched = false;

    public TvShowSyncTraktTvTask(List<TvShow> tvShows) {
        super(TmmResourceBundle.getString("trakt.sync"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.tvShows.addAll(tvShows);
    }

    public void setSyncCollection(boolean value) {
        this.syncCollection = value;
    }

    public void setSyncWatched(boolean value) {
        this.syncWatched = value;
    }

    public void setSyncRating(boolean value) {
        this.syncRating = value;
    }

    public void setRemoveFromCollection(boolean value) {
        this.removeFromCollection = value;
    }

    public void setRemoveFromWatched(boolean value) {
        this.removeFromWatched = value;
    }

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        if (!this.syncNeeded(this.tvShows)) {
            return;
        }
        TraktTv traktTV = TraktTv.getInstance();
        if (this.syncCollection) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.tvshow"), 0);
            try {
                traktTV.syncTraktTvShowCollection(this.tvShows);
            }
            catch (Exception e) {
                LOGGER.error("Failed syncing Trakt.tv - '{}'", (Object)e.getMessage());
            }
        }
        if (this.removeFromCollection) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.tvshow.remove"), 0);
            try {
                traktTV.removeFromTraktTvShowCollection(this.tvShows);
            }
            catch (Exception e) {
                LOGGER.error("Failed syncing Trakt.tv - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncWatched) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.tvshowwatched"), 0);
            try {
                traktTV.syncTraktTvShowWatched(this.tvShows);
            }
            catch (Exception e) {
                LOGGER.error("Failed syncing Trakt.tv - '{}'", (Object)e.getMessage());
            }
        }
        if (this.removeFromWatched) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.tvshowwatched.remove"), 0);
            try {
                traktTV.removeFromTraktTvShowWatched(this.tvShows);
            }
            catch (Exception e) {
                LOGGER.error("Failed syncing Trakt.tv - '{}'", (Object)e.getMessage());
            }
        }
        if (this.syncRating) {
            this.publishState(TmmResourceBundle.getString("trakt.sync.tvshowrating"), 0);
            try {
                traktTV.syncTraktTvShowRating(this.tvShows);
            }
            catch (Exception e) {
                LOGGER.error("Failed syncing Trakt.tv - '{}'", (Object)e.getMessage());
            }
        }
    }

    private boolean syncNeeded(List<TvShow> tvShows) {
        for (TvShow tvShow : tvShows) {
            if (tvShow.getIdAsInt("tvdb") > 0) {
                return true;
            }
            if (tvShow.getTmdbId() > 0) {
                return true;
            }
            if (tvShow.getTraktId() > 0) {
                return true;
            }
            if (!MediaIdUtil.isValidImdbId(tvShow.getImdbId())) continue;
            return true;
        }
        return false;
    }
}

