/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.tmdb.TmdbController;
import org.tinymediamanager.scraper.tmdb.entities.Configuration;
import org.tinymediamanager.scraper.tmdb.entities.ExternalIds;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Translations;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

abstract class TmdbMetadataProvider
implements IMediaProvider {
    static final String ID = "tmdb";
    protected static final String[] PT = new String[]{"af-ZA", "ar-AE", "ar-BH", "ar-EG", "ar-IQ", "ar-JO", "ar-LY", "ar-MA", "ar-QA", "ar-SA", "ar-TD", "ar-YE", "be-BY", "bg-BG", "bn-BD", "br-FR", "ca-AD", "ca-ES", "ch-GU", "cs-CZ", "cy-GB", "da-DK", "de-AT", "de-CH", "de-DE", "el-CY", "el-GR", "en-AG", "en-AU", "en-BB", "en-BZ", "en-CA", "en-CM", "en-GB", "en-GG", "en-GH", "en-GI", "en-GY", "en-IE", "en-JM", "en-KE", "en-LC", "en-MW", "en-NZ", "en-PG", "en-TC", "en-US", "en-ZM", "en-ZW", "eo-EO", "es-AR", "es-CL", "es-DO", "es-EC", "es-ES", "es-GQ", "es-GT", "es-HN", "es-MX", "es-NI", "es-PA", "es-PE", "es-PY", "es-SV", "es-UY", "et-EE", "eu-ES", "fa-IR", "fi-FI", "fr-BF", "fr-CA", "fr-CD", "fr-CI", "fr-FR", "fr-GF", "fr-GP", "fr-MC", "fr-ML", "fr-MU", "fr-PF", "ga-IE", "gd-GB", "gl-ES", "he-IL", "hi-IN", "hr-HR", "hu-HU", "id-ID", "it-IT", "it-VA", "ja-JP", "ka-GE", "kk-KZ", "kn-IN", "ko-KR", "ku-TR", "ky-KG", "lt-LT", "lv-LV", "ml-IN", "mr-IN", "ms-MY", "ms-SG", "nb-NO", "nl-BE", "nl-NL", "no-NO", "pa-IN", "pl-PL", "pt-AO", "pt-BR", "pt-MZ", "pt-PT", "ro-MD", "ro-RO", "ru-RU", "si-LK", "sk-SK", "sl-SI", "so-SO", "sq-AL", "sq-XK", "sr-ME", "sr-RS", "sv-SE", "sw-TZ", "ta-IN", "te-IN", "th-TH", "tl-PH", "tr-TR", "uk-UA", "ur-PK", "uz-UZ", "vi-VN", "zh-CN", "zh-HK", "zh-SG", "zh-TW", "zu-ZA"};
    protected static final String[] EPISODE_TRANS = new String[]{"Episode", "\u062d\u0644\u0642\u0629", "\u0415\u043f\u0438\u0437\u043e\u0434", "Episodi", "epizoda", "Afsnit", "\u0395\u03c0\u03b5\u03b9\u03c3\u03cc\u03b4\u03b9\u03bf", "Episodio", "Atala", "\u202b\u0642\u0633\u0645\u062a", "Jakso", "\u00c9pisode", "\u05e4\u05e8\u05e7", "Epizoda", "epiz\u00f3d", "Ep\u0131zod", "\uc5d0\ud53c\uc18c\ub4dc", "Epizodas", "Epizode", "Aflevering", "Odcinek", "Epis\u00f3dio", "Episodul", "\u042d\u043f\u0438\u0437\u043e\u0434", "Epiz\u00f3da", "Xalqada", "\u0415\u043f\u0438\u0437\u043e\u0434\u0430", "Avsnitt", "B\u00f6l\u00fcm", "\u0421\u0435\u0440\u0456\u044f", "\u7b2c\u8a71", "\u7b2c  \u96c6"};
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected TmdbController api;
    protected Configuration configuration;
    protected String artworkBaseUrl;

    TmdbMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "themoviedb.org", "<html><h3>The Movie Database (TMDb)</h3><br />The largest free movie database maintained by the community. It provides metadata and artwork<br />in many different languages. Thus it is the first choice for non english users<br /><br />Available languages: multiple</html>", TmdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/themoviedb_org.svg"), 50);
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addBoolean("alternateServer", false);
        return info;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getUserApiKey());
    }

    protected synchronized void initAPI() throws ScrapeException {
        String userApiKey;
        if (this.api != null) {
            userApiKey = this.providerInfo.getUserApiKey();
            if (StringUtils.isNotBlank((CharSequence)userApiKey) && !userApiKey.equals(this.api.apiKey())) {
                this.api = null;
            } else if (StringUtils.isBlank((CharSequence)userApiKey) && !this.getApiKey().equals(this.api.apiKey())) {
                this.api = null;
            } else if (this.providerInfo.getConfig().getValueAsBool("alternateServer") != this.api.isAlternateServer()) {
                this.api = null;
            }
        }
        if (this.api == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                userApiKey = this.providerInfo.getUserApiKey();
                this.api = new TmdbController(StringUtils.isNotBlank((CharSequence)userApiKey) ? userApiKey : this.getApiKey(), this.providerInfo.getConfig().getValueAsBool("alternateServer"));
                Response response = this.api.configurationService().configuration().execute();
                if (response.code() == 401) {
                    throw new ScrapeException("Invalid TMDB API key");
                }
                if (response.body() == null) {
                    throw new ScrapeException("Could not contact TMDB API - " + response.message());
                }
                this.configuration = (Configuration)response.body();
                this.artworkBaseUrl = this.configuration.images.secure_base_url;
            }
            catch (ScrapeException e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw e;
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    protected abstract Logger getLogger();

    protected Translations.Translation getTranslationForLocale(Translations translations, Locale locale) {
        Translations.Translation ret = null;
        if (translations != null && translations.translations != null && !translations.translations.isEmpty()) {
            for (Translations.Translation tr : translations.translations) {
                if (!tr.iso_639_1.equals(locale.getLanguage()) || !tr.iso_3166_1.equals(locale.getCountry())) continue;
                ret = tr;
                break;
            }
            if (ret == null) {
                block5 : switch (locale.toString()) {
                    case "es_MX": 
                    case "pt_BR": 
                    case "fr_CA": {
                        break;
                    }
                    default: {
                        for (Translations.Translation tr : translations.translations) {
                            if (!tr.iso_639_1.equals(locale.getLanguage()) && !tr.iso_3166_1.equals(locale.getCountry())) continue;
                            ret = tr;
                            break block5;
                        }
                    }
                }
            }
        }
        return ret;
    }

    protected String[] getValuesFromTranslation(Translations translations, Locale locale) {
        String[] ret = new String[]{"", ""};
        Translations.Translation tr = this.getTranslationForLocale(translations, locale);
        if (tr == null || tr.data == null) {
            return ret;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.title)) {
            ret[0] = tr.data.title;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.name)) {
            ret[0] = tr.data.name;
        }
        if (StringUtils.isNotBlank((CharSequence)tr.data.overview)) {
            ret[1] = tr.data.overview;
        }
        return ret;
    }

    static MediaGenres getTmmGenre(Genre genre) {
        if (genre == null || MetadataUtil.unboxInteger(genre.id) == 0) {
            return null;
        }
        MediaGenres g = null;
        switch (genre.id) {
            case 28: 
            case 10759: {
                g = MediaGenres.ACTION;
                break;
            }
            case 12: {
                g = MediaGenres.ADVENTURE;
                break;
            }
            case 16: {
                g = MediaGenres.ANIMATION;
                break;
            }
            case 35: {
                g = MediaGenres.COMEDY;
                break;
            }
            case 80: {
                g = MediaGenres.CRIME;
                break;
            }
            case 105: {
                g = MediaGenres.DISASTER;
                break;
            }
            case 99: {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case 18: {
                g = MediaGenres.DRAMA;
                break;
            }
            case 82: {
                g = MediaGenres.EASTERN;
                break;
            }
            case 2916: {
                g = MediaGenres.EROTIC;
                break;
            }
            case 10751: {
                g = MediaGenres.FAMILY;
                break;
            }
            case 10750: {
                g = MediaGenres.FAN_FILM;
                break;
            }
            case 14: {
                g = MediaGenres.FANTASY;
                break;
            }
            case 10753: {
                g = MediaGenres.FILM_NOIR;
                break;
            }
            case 10769: {
                g = MediaGenres.FOREIGN;
                break;
            }
            case 36: {
                g = MediaGenres.HISTORY;
                break;
            }
            case 10595: {
                g = MediaGenres.HOLIDAY;
                break;
            }
            case 27: {
                g = MediaGenres.HORROR;
                break;
            }
            case 10756: {
                g = MediaGenres.INDIE;
                break;
            }
            case 10402: {
                g = MediaGenres.MUSIC;
                break;
            }
            case 22: {
                g = MediaGenres.MUSICAL;
                break;
            }
            case 9648: {
                g = MediaGenres.MYSTERY;
                break;
            }
            case 10754: {
                g = MediaGenres.NEO_NOIR;
                break;
            }
            case 10763: {
                g = MediaGenres.NEWS;
                break;
            }
            case 10764: {
                g = MediaGenres.REALITY_TV;
                break;
            }
            case 1115: {
                g = MediaGenres.ROAD_MOVIE;
                break;
            }
            case 10749: {
                g = MediaGenres.ROMANCE;
                break;
            }
            case 878: 
            case 10765: {
                g = MediaGenres.SCIENCE_FICTION;
                break;
            }
            case 10755: {
                g = MediaGenres.SHORT;
                break;
            }
            case 10766: {
                g = MediaGenres.SOAP;
                break;
            }
            case 9805: {
                g = MediaGenres.SPORT;
                break;
            }
            case 10758: {
                g = MediaGenres.SPORTING_EVENT;
                break;
            }
            case 10757: {
                g = MediaGenres.SPORTS_FILM;
                break;
            }
            case 10748: {
                g = MediaGenres.SUSPENSE;
                break;
            }
            case 10767: {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case 10770: {
                g = MediaGenres.TV_MOVIE;
                break;
            }
            case 53: {
                g = MediaGenres.THRILLER;
                break;
            }
            case 10752: 
            case 10768: {
                g = MediaGenres.WAR;
                break;
            }
            case 37: {
                g = MediaGenres.WESTERN;
            }
        }
        if (g == null) {
            g = MediaGenres.getGenre(genre.name);
        }
        return g;
    }

    protected Map<String, Object> parseExternalIDs(ExternalIds ids) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (ids != null) {
            if (StringUtils.isNotBlank((CharSequence)ids.imdb_id)) {
                ret.put("imdb", ids.imdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)ids.wikidata_id)) {
                ret.put("wikidata", ids.wikidata_id);
            }
            if (ids.tvdb_id != null && ids.tvdb_id > 0) {
                ret.put("tvdb", ids.tvdb_id);
            }
            if (ids.tvrage_id != null && ids.tvrage_id > 0) {
                ret.put("tvrage", ids.tvrage_id);
            }
        }
        return ret;
    }

    static String getRequestLanguage(@NotNull MediaLanguages language) {
        Locale locale;
        String name = language.name();
        if (name.length() > 2) {
            locale = language.toLocale();
        } else {
            locale = new Locale(name, name.toUpperCase(Locale.ROOT));
            if (!LocaleUtils.isAvailableLocale((Locale)locale)) {
                locale = language.toLocale();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.toLanguageTag();
    }
}

