/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class TvShowEpisodeScrapeTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeScrapeTask.class);
    private final List<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
    private final List<TvShowEpisodeScraperMetadataConfig> config = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
    private final TvShowEpisodeSearchAndScrapeOptions scrapeOptions;
    private final boolean overwrite;

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, TvShowEpisodeSearchAndScrapeOptions options, List<TvShowEpisodeScraperMetadataConfig> config, boolean overwrite) {
        super(TmmResourceBundle.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes.addAll(episodes);
        this.config.addAll(config);
        this.scrapeOptions = options;
        this.overwrite = overwrite;
    }

    @Override
    public void doInBackground() {
        this.setWorkUnits(this.episodes.size());
        MediaScraper mediaScraper = this.scrapeOptions.getMetadataScraper();
        if (!mediaScraper.isEnabled()) {
            return;
        }
        int count = 0;
        for (TvShowEpisode episode : this.episodes) {
            this.publishState(count++);
            if (episode.getTvShow().getIds().isEmpty()) {
                LOGGER.warn("Cannot scrape episode (no ID available): '{}' - '{}'", (Object)episode.getTvShow().getTitle(), (Object)episode.getTitle());
                continue;
            }
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(this.scrapeOptions);
            MediaMetadata md = new MediaMetadata(mediaScraper.getMediaProvider().getProviderInfo().getId());
            md.setScrapeOptions(options);
            md.setReleaseDate(episode.getFirstAired());
            md.setTitle(episode.getTitle());
            options.setMetadata(md);
            options.setIds(episode.getIds());
            options.setEpisodeGroup(episode.getEpisodeGroup());
            if (episode.getSeason() > -1 && episode.getEpisode() > -1) {
                options.setId("seasonNr", episode.getSeason());
                options.setId("episodeNr", episode.getEpisode());
            } else {
                options.setId("seasonNr", episode.getAiredSeason());
                options.setId("episodeNr", episode.getAiredEpisode());
            }
            options.setTvShowIds(episode.getTvShow().getIds());
            try {
                LOGGER.info("Scraping episode '{}' (S{} E{}) with '{}'", new Object[]{episode.getTitle(), episode.getSeason(), episode.getEpisode(), mediaScraper.getMediaProvider().getProviderInfo().getId()});
                LOGGER.debug("=====================================================");
                LOGGER.debug("Scrape episode metadata with scraper: {}", (Object)mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.debug(options.toString());
                LOGGER.debug("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)mediaScraper.getMediaProvider()).getMetadata(options);
                metadata.setId("tvShowIds", options.getTvShowIds());
                MediaIdUtil.injectMissingIds(metadata.getIds(), MediaType.TV_EPISODE);
                if (TvShowModuleManager.getInstance().getSettings().isFetchAllRatings() && this.config.contains(TvShowEpisodeScraperMetadataConfig.RATING)) {
                    for (MediaRating rating : ListUtils.nullSafe(RatingProvider.getRatings(metadata.getIds(), TvShowModuleManager.getInstance().getSettings().getFetchRatingSources(), MediaType.TV_EPISODE))) {
                        if (metadata.getRatings().contains(rating)) continue;
                        metadata.addRating(rating);
                    }
                }
                metadata.removeId("tvShowIds");
                if (StringUtils.isNotBlank((CharSequence)metadata.getTitle())) {
                    episode.setMetadata(metadata, this.config, this.overwrite);
                    episode.setLastScraperId(this.scrapeOptions.getMetadataScraper().getId());
                    episode.setLastScrapeLanguage(this.scrapeOptions.getLanguage().name());
                    episode.saveToDb();
                }
                if (this.cancel) {
                    return;
                }
                if (ScraperMetadataConfig.containsAnyArtwork(this.config)) {
                    int preferredSizeOrder;
                    List<MediaArtwork.ImageSizeAndUrl> sortedThumbs;
                    List<MediaArtwork> artworks = this.getArtwork(episode, metadata, options);
                    artworks.addAll(metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB));
                    if (this.config.contains(TvShowEpisodeScraperMetadataConfig.THUMB) && (this.overwrite || StringUtils.isBlank((CharSequence)episode.getArtworkFilename(MediaFileType.THUMB))) && !(sortedThumbs = TvShowArtworkHelper.sortArtworkUrls(artworks, MediaArtwork.MediaArtworkType.THUMB, preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder())).isEmpty()) {
                        MediaArtwork.ImageSizeAndUrl foundThumb = sortedThumbs.get(0);
                        episode.setArtworkUrl(foundThumb.getUrl(), MediaFileType.THUMB);
                        episode.downloadArtwork(MediaFileType.THUMB, false);
                        episode.saveToDb();
                        episode.writeNFO();
                    }
                }
                if (!this.cancel) continue;
                return;
            }
            catch (MissingIdException e) {
                LOGGER.warn("Missing IDs for scraping TV show '{}', episode '{}' with '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), mediaScraper.getId()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, episode, "scraper.error.missingid"));
            }
            catch (NothingFoundException e) {
                LOGGER.info("Nothing found for scraping TV show '{}', episode '{}' with '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), mediaScraper.getId()});
            }
            catch (ScrapeException e) {
                LOGGER.error("Could not scrape TV show '{}', episode '{}' with '{}' - '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), mediaScraper.getId(), e.getMessage()});
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (Exception e) {
                LOGGER.error("Unforeseen error in episode scrape for '{}' - '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), e});
            }
        }
        if (this.cancel) {
            return;
        }
        if (TvShowModuleManager.getInstance().getSettings().isRenameAfterScrape()) {
            for (TvShowEpisode episode : this.episodes) {
                TvShowRenamer.renameEpisode(episode);
            }
        }
        if (ScraperMetadataConfig.containsAnyCast(this.config) && TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            for (TvShowEpisode episode : this.episodes) {
                episode.writeActorImages(this.overwrite);
            }
        }
    }

    private List<MediaArtwork> getArtwork(TvShowEpisode episode, MediaMetadata metadata, TvShowEpisodeSearchAndScrapeOptions scrapeOptions) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_EPISODE);
        options.setDataFromOtherOptions(scrapeOptions);
        options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
        options.setMetadata(metadata);
        options.addIds(episode.getIds());
        options.setId("tvShowIds", episode.getTvShow().getIds());
        options.setId("mediaFile", episode.getMainFile());
        options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
        options.setEpisodeGroup(episode.getEpisodeGroup());
        scrapeOptions.getArtworkScrapers().parallelStream().forEach(artworkScraper -> {
            if (TvShowModuleManager.getInstance().getSettings().isImageEpisodeScrapeAllSources() || artworkScraper.getId().equals(scrapeOptions.getMetadataScraper().getId())) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    lock.writeLock().lock();
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.warn("Missing IDs for getting artwork for TV show '{}', episode '{}' with '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), artworkScraper.getId()});
                }
                catch (ScrapeException e) {
                    LOGGER.error("Could not scrape artwork for TV show '{}', episode '{}' with '{}' - '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), artworkProvider.getId(), e.getMessage()});
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (Exception e) {
                    LOGGER.error("Unforeseen error in movie artwork scrape for TV show '{}', episode '{}' with '{}'", new Object[]{episode.getTvShow().getTitle(), episode.getTitle(), artworkProvider.getId(), e});
                }
                finally {
                    lock.writeLock().unlock();
                }
            }
        });
        artwork.sort((o1, o2) -> {
            if (o1.getBiggestArtwork() == null || o2.getBiggestArtwork() == null) {
                return 0;
            }
            return Integer.compare(o2.getBiggestArtwork().getWidth(), o1.getBiggestArtwork().getWidth());
        });
        return artwork;
    }
}

