/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.w3c.dom.Element;

public class MovieToMpMovingPicturesConnector
extends MovieGenericXmlConnector {
    public MovieToMpMovingPicturesConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addOwnTags() {
    }

    @Override
    protected void addMpaa() {
        Element mpaa = this.document.createElement("mpaa");
        if (this.movie.getCertification() != null) {
            mpaa.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), MovieModuleManager.getInstance().getSettings().getCertificationStyle()));
        }
        this.root.appendChild(mpaa);
    }

    @Override
    protected void addCertification() {
    }

    @Override
    protected void addCountry() {
        Element country = this.document.createElement("country");
        List<String> countries = ParserUtils.split(this.movie.getCountry());
        country.setTextContent(StringUtils.join(countries, (String)", "));
        this.root.appendChild(country);
    }

    @Override
    protected void addStudios() {
        Element studio = this.document.createElement("studio");
        List<String> studios = ParserUtils.split(this.movie.getProductionCompany());
        if (MovieModuleManager.getInstance().getSettings().isNfoWriteSingleStudio()) {
            if (!studios.isEmpty()) {
                studio.setTextContent(studios.get(0));
            }
        } else {
            studio.setTextContent(StringUtils.join(studios, (String)", "));
        }
        this.root.appendChild(studio);
    }

    @Override
    protected void addCredits() {
        Element credits = this.document.createElement("credits");
        credits.setTextContent(this.movie.getWritersAsString());
        this.root.appendChild(credits);
    }

    @Override
    protected void addDirectors() {
        Element director = this.document.createElement("director");
        director.setTextContent(this.movie.getDirectorsAsString());
        this.root.appendChild(director);
    }

    @Override
    protected void addLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (String langu : ParserUtils.split(this.movie.getSpokenLanguages())) {
            String translated = LanguageUtils.getLocalizedLanguageNameFromLocalizedString(MovieModuleManager.getInstance().getSettings().getNfoLanguage(), langu.strip());
            languages.add(translated);
        }
        Element element = this.document.createElement("language");
        element.setTextContent(StringUtils.join(languages, (String)", "));
        this.root.appendChild(element);
    }
}

