/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.types.BytesRange;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;
import org.jupnp.support.model.dlna.types.AvailableSeekRangeType;
import org.jupnp.support.model.dlna.types.NormalPlayTimeRange;

public class AvailableSeekRangeHeader
extends DLNAHeader<AvailableSeekRangeType> {
    public AvailableSeekRangeHeader() {
    }

    public AvailableSeekRangeHeader(AvailableSeekRangeType timeSeekRange) {
        this.setValue(timeSeekRange);
    }

    public void setString(String s) {
        String[] params;
        if (!s.isEmpty() && (params = s.split(" ")).length > 1) {
            try {
                AvailableSeekRangeType.Mode mode = null;
                NormalPlayTimeRange timeRange = null;
                BytesRange byteRange = null;
                try {
                    mode = AvailableSeekRangeType.Mode.valueOf("MODE_" + params[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidValueException("Invalid AvailableSeekRange Mode");
                }
                boolean useTime = true;
                try {
                    timeRange = NormalPlayTimeRange.valueOf(params[1], true);
                }
                catch (InvalidValueException timeInvalidValueException) {
                    try {
                        byteRange = BytesRange.valueOf((String)params[1]);
                        useTime = false;
                    }
                    catch (InvalidValueException bytesInvalidValueException) {
                        throw new InvalidValueException("Invalid AvailableSeekRange Range");
                    }
                }
                if (useTime) {
                    if (params.length > 2) {
                        byteRange = BytesRange.valueOf((String)params[2]);
                        this.setValue(new AvailableSeekRangeType(mode, timeRange, byteRange));
                    } else {
                        this.setValue(new AvailableSeekRangeType(mode, timeRange));
                    }
                } else {
                    this.setValue(new AvailableSeekRangeType(mode, byteRange));
                }
                return;
            }
            catch (InvalidValueException e) {
                throw new InvalidHeaderException("Invalid AvailableSeekRange header value: " + s + "; " + e.getMessage(), (Throwable)e);
            }
        }
        throw new InvalidHeaderException("Invalid AvailableSeekRange header value: " + s);
    }

    public String getString() {
        AvailableSeekRangeType t = (AvailableSeekRangeType)this.getValue();
        Object s = Integer.toString(t.getModeFlag().ordinal());
        if (t.getNormalPlayTimeRange() != null) {
            s = (String)s + " " + t.getNormalPlayTimeRange().getString(false);
        }
        if (t.getBytesRange() != null) {
            s = (String)s + " " + t.getBytesRange().getString(false);
        }
        return s;
    }
}

