/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.services;

import com.uwetrottmann.trakt5.entities.Comment;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.Ratings;
import com.uwetrottmann.trakt5.entities.Stats;
import com.uwetrottmann.trakt5.entities.TrendingMovie;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface Movies {
    @GET(value="movies/popular")
    public Call<List<Movie>> popular(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="movies/trending")
    public Call<List<TrendingMovie>> trending(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="movies/{id}")
    public Call<Movie> summary(@Path(value="id") String var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="movies/{id}/translations")
    public Call<List<MovieTranslation>> translations(@Path(value="id") String var1);

    @GET(value="movies/{id}/translations/{language}")
    public Call<List<MovieTranslation>> translation(@Path(value="id") String var1, @Path(value="language") String var2);

    @GET(value="movies/{id}/comments")
    public Call<List<Comment>> comments(@Path(value="id") String var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encoded=true) Extended var4);

    @GET(value="movies/{id}/comments")
    public Call<List<Comment>> comments(@Path(value="id") String var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encoded=true) Extended var4, @Header(value="Cache-Control") String var5);

    @GET(value="movies/{id}/people")
    public Call<Credits> people(@Path(value="id") String var1);

    @GET(value="movies/{id}/ratings")
    public Call<Ratings> ratings(@Path(value="id") String var1);

    @GET(value="movies/{id}/stats")
    public Call<Stats> stats(@Path(value="id") String var1);
}

