/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;

public class RatingPanel
extends JPanel {
    private final Locale defaultLocale = Locale.getDefault();

    public RatingPanel() {
        this.setLayout(new FlowLayout(0, 15, 0));
        this.setOpaque(false);
    }

    public void setRatings(Map<String, MediaRating> newRatings) {
        this.updateRatings(Objects.requireNonNullElse(newRatings, Collections.emptyMap()));
    }

    private void updateRatings(Map<String, MediaRating> ratings) {
        MediaRating rating;
        this.removeAll();
        ArrayList<MediaRating> addedRatings = new ArrayList<MediaRating>();
        MediaRating userRating = ratings.get("user");
        if (userRating != null) {
            addedRatings.add(userRating);
            this.add(new RatingContainer(userRating));
        }
        if ((rating = ratings.get("imdb")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("tomatometerallcritics")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("metacritic")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("tmdb")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("tvdb")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("trakt")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("letterboxd")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("myanimelist")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("rogerebert")) != null) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if ((rating = ratings.get("custom")) != null && !addedRatings.contains(rating)) {
            addedRatings.add(rating);
            this.add(new RatingContainer(rating));
        }
        if (addedRatings.isEmpty()) {
            rating = ratings.get("default");
            if (rating == null) {
                rating = ratings.get("NFO");
            }
            if (rating != null) {
                addedRatings.add(rating);
                this.add(new RatingContainer(rating));
            }
        }
        if (addedRatings.isEmpty()) {
            this.add(new RatingContainer(MediaMetadata.EMPTY_RATING));
        }
        this.revalidate();
        this.repaint();
    }

    private class RatingContainer
    extends JPanel {
        public RatingContainer(MediaRating rating) {
            this.setOpaque(false);
            this.setLayout((LayoutManager)new MigLayout("", "[]10lp[center]", "[]"));
            JLabel logo = null;
            JLabel value = null;
            JLabel votes = null;
            switch (rating.getId()) {
                case "user": {
                    logo = new JLabel(IconManager.RATING_USER);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "imdb": {
                    logo = new JLabel(IconManager.RATING_IMDB);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "tmdb": {
                    logo = new JLabel(IconManager.RATING_TMDB);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "tomatometerallcritics": {
                    logo = new JLabel(IconManager.RATING_TOMATOMETER);
                    value = new JLabel(String.format("%.0f%%", Float.valueOf(rating.getRating())));
                    break;
                }
                case "metacritic": {
                    logo = new JLabel(IconManager.RATING_METACRITIC);
                    value = new JLabel(String.format("%.0f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "tvdb": {
                    logo = new JLabel(IconManager.RATING_THETVDB);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "trakt": {
                    logo = new JLabel(IconManager.RATING_TRAKTTV);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "letterboxd": {
                    logo = new JLabel(IconManager.RATING_LETTERBOXD);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "myanimelist": {
                    logo = new JLabel(IconManager.RATING_MAL);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "rogerebert": {
                    logo = new JLabel(IconManager.RATING_ROGEREBERT);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                    break;
                }
                case "": {
                    logo = new JLabel(IconManager.RATING_EMTPY);
                    value = new JLabel("?");
                    break;
                }
                default: {
                    logo = new JLabel(IconManager.RATING_NEUTRAL);
                    value = new JLabel(String.format("%.1f", Float.valueOf(rating.getRating())));
                }
            }
            if (rating.getVotes() > 1) {
                votes = new JLabel(String.format(RatingPanel.this.defaultLocale, "%,d", rating.getVotes()));
            }
            if (logo != null && value != null) {
                String tooltipText = this.createTooltipText(rating);
                logo.setToolTipText(tooltipText);
                this.add((Component)logo, "cell 0 0");
                TmmFontHelper.changeFont(value, 1.33333, 1);
                value.setToolTipText(tooltipText);
                this.add((Component)value, "flowy, cell 1 0, ");
                if (votes != null) {
                    TmmFontHelper.changeFont((JComponent)votes, 0.83333);
                    this.add((Component)votes, "cell 1 0, gapy 0");
                }
            }
        }

        private String createTooltipText(MediaRating rating) {
            Object tooltipText = "";
            switch (rating.getId()) {
                case "default": 
                case "NFO": {
                    break;
                }
                case "user": {
                    tooltipText = TmmResourceBundle.getString("rating.personal") + ": ";
                    break;
                }
                case "imdb": {
                    tooltipText = "IMDb: ";
                    break;
                }
                case "tmdb": {
                    tooltipText = "TMDB: ";
                    break;
                }
                case "tomatometerallcritics": {
                    tooltipText = "Rotten Tomatoes: ";
                    break;
                }
                case "metacritic": {
                    tooltipText = "Metascore: ";
                    break;
                }
                case "tvdb": {
                    tooltipText = "TheTVDB: ";
                    break;
                }
                case "trakt": {
                    tooltipText = "Trakt.tv: ";
                    break;
                }
                case "": {
                    tooltipText = TmmResourceBundle.getString("rating.empty");
                    break;
                }
                default: {
                    tooltipText = rating.getId() + ": ";
                }
            }
            if (rating == MediaMetadata.EMPTY_RATING) {
                return tooltipText;
            }
            if (rating.getVotes() > 1) {
                return (String)tooltipText + String.format(RatingPanel.this.defaultLocale, "%.1f / %,d (%,d %s)", Float.valueOf(rating.getRating()), rating.getMaxValue(), rating.getVotes(), TmmResourceBundle.getString("metatag.votes"));
            }
            return (String)tooltipText + String.format(RatingPanel.this.defaultLocale, "%.1f / %,d", Float.valueOf(rating.getRating()), rating.getMaxValue());
        }
    }
}

