/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class ImdbMovieParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbMovieParser.class);

    ImdbMovieParser(IMediaProvider mediaProvider, ExecutorService executor) {
        super(mediaProvider, MediaType.MOVIE, executor);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected boolean isIncludeMovieResults() {
        return true;
    }

    @Override
    protected MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        return this.getMovieMetadata((MovieSearchAndScrapeOptions)options);
    }

    MediaMetadata getMovieMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        MediaMetadata md = new MediaMetadata("imdb");
        md.setScrapeOptions(options);
        if (options.getMetadata() != null && "imdb".equals(options.getMetadata().getProviderId())) {
            LOGGER.debug("IMDB: got metadata from cache: {}", (Object)options.getMetadata());
            return options.getMetadata();
        }
        String imdbId = "";
        if (options.getSearchResult() != null) {
            imdbId = options.getSearchResult().getIMDBId();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getMovieImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        md.setId("imdb", imdbId);
        Document doc = null;
        boolean json = false;
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
        Future<Document> futureDetail = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L3JlZmVyZW5jZQ==")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
        Future<Document> futureReference = this.executor.submit(worker);
        worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L2Z1bGxjcmVkaXRz")), "en", "US", true);
        Future<Document> futureCredits = this.executor.submit(worker);
        Future<Document> futureKeywords = null;
        if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5) {
            worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L2tleXdvcmRz")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            futureKeywords = this.executor.submit(worker);
        }
        Future<Document> futureReleaseInfo = null;
        if (!this.isScrapeLocalReleaseDate()) {
            worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L3JlbGVhc2VpbmZv")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            futureReleaseInfo = this.executor.submit(worker);
        }
        try {
            doc = futureDetail.get();
            this.parseDetailPageJson(doc, options, md);
            json = true;
        }
        catch (Exception e) {
            LOGGER.debug("Could not get detailpage for id '{}' - '{}'", (Object)imdbId, (Object)e.getMessage());
        }
        if (json) {
            try {
                MediaMetadata md2 = new MediaMetadata("imdb");
                doc = futureReference.get();
                if (doc != null) {
                    this.parseReferencePage(doc, options, md2);
                    md.setTagline(md2.getTagline());
                    md.setCastMembers(md2.getCastMembers());
                    md.setTop250(md2.getTop250());
                    md2.getCertifications().forEach(md::addCertification);
                }
                if (md.getCastMembers().isEmpty() && (doc = futureCredits.get()) != null) {
                    this.parseFullcreditsPage(doc, options, md);
                }
                if (this.isScrapeKeywordsPage() && this.getMaxKeywordCount() > 5 && futureKeywords != null && (doc = futureKeywords.get()) != null) {
                    this.parseKeywordsPage(doc, options, md2);
                    md2.getTags().forEach(md::addTag);
                }
                if (!this.isScrapeLocalReleaseDate() && futureReleaseInfo != null && (doc = futureReleaseInfo.get()) != null) {
                    this.parseReleaseinfoPageJson(doc, options, md2);
                    md.setReleaseDate(md2.getReleaseDate());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse page: {}", (Object)e.getMessage());
            }
        } else {
            worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L3Bsb3RzdW1tYXJ5")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futurePlotsummary = this.executor.submit(worker);
            worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L3JlbGVhc2VpbmZv")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
            Future<Document> futureReleaseinfo = this.executor.submit(worker);
            Future<Document> futureCritics = null;
            if (Boolean.TRUE.equals(this.config.getValueAsBool("includeMetacritic"))) {
                worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L2NyaXRpY3Jldmlld3M=")), options.getLanguage().getLanguage(), options.getCertificationCountry().getAlpha2(), true);
                futureCritics = this.executor.submit(worker);
            }
            try {
                Document criticsDoc;
                Document releaseinfoDoc;
                doc = futureReference.get();
                if (doc != null) {
                    this.parseReferencePage(doc, options, md);
                }
                if ((doc = futurePlotsummary.get()) != null) {
                    this.parsePlotsummaryPage(doc, options, md);
                }
                if (futureKeywords != null && (doc = futureKeywords.get()) != null) {
                    this.parseKeywordsPage(doc, options, md);
                }
                if ((releaseinfoDoc = futureReleaseinfo.get()) != null) {
                    this.parseReleaseinfoPageAKAs(releaseinfoDoc, md);
                    this.parseReleaseinfoPage(releaseinfoDoc, options, md);
                }
                if (futureCritics != null && (criticsDoc = (Document)futureCritics.get()) != null) {
                    this.parseCritics(criticsDoc, md);
                }
            }
            catch (Exception e) {
                LOGGER.debug("problem while scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            if (md.getIds().isEmpty()) {
                LOGGER.debug("nothing found");
                throw new NothingFoundException();
            }
        }
        if (StringUtils.isBlank((CharSequence)md.getOriginalTitle())) {
            md.setOriginalTitle(md.getTitle());
        }
        md.setId("imdb", imdbId);
        return md;
    }

    public List<MediaRating> getRatings(Map<String, Object> ids) throws ScrapeException {
        LOGGER.debug("getRatings(): {}", ids);
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        MediaMetadata md = new MediaMetadata("imdb");
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(this, this.constructUrl("title/", imdbId, this.decode("L2NyaXRpY3Jldmlld3M=")), "en", "US", true);
        Future<Document> futureCritics = this.executor.submit(worker);
        try {
            Document criticsDoc = futureCritics.get();
            if (criticsDoc != null) {
                this.parseCritics(criticsDoc, md);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not get ratings - '{}'", (Object)e.getMessage());
        }
        MediaRating imdbRating = RatingProvider.getImdbRating(imdbId);
        if (imdbRating != null) {
            md.addRating(imdbRating);
        }
        return md.getRatings();
    }

    private void parseCritics(Document doc, MediaMetadata md) {
        for (Element div : doc.getElementsByClass("metascore_block")) {
            int value = 0;
            int count = 0;
            Elements spans = div.getElementsByTag("span");
            for (Element span : spans) {
                if ("ratingValue".equals(span.attr("itemprop"))) {
                    value = MetadataUtil.parseInt(span.text(), 0);
                }
                if (!"ratingCount".equals(span.attr("itemprop"))) continue;
                count = MetadataUtil.parseInt(span.text(), 0);
            }
            if (value <= 0) continue;
            MediaRating rating = new MediaRating("metacritic");
            rating.setRating(value);
            rating.setVotes(count);
            rating.setMaxValue(100);
            md.addRating(rating);
            break;
        }
    }

    private void parseReleaseinfoPageAKAs(Document doc, MediaMetadata md) {
        block0: for (Element table : doc.getElementsByTag("table")) {
            if (!table.id().equalsIgnoreCase("akas")) continue;
            Elements rows = table.getElementsByTag("tr");
            for (Element row : rows) {
                Element c1 = (Element)row.getElementsByTag("td").get(0);
                Element c2 = (Element)row.getElementsByTag("td").get(1);
                if (c1 == null || !c1.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
                md.setOriginalTitle(c2.text());
                continue block0;
            }
        }
        Elements rows = doc.getElementsByClass("aka-item");
        for (Element row : rows) {
            Element country = row.getElementsByClass("aka-item__name").first();
            Element title = row.getElementsByClass("aka-item__title").first();
            if (country == null || !country.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
            md.setOriginalTitle(title.text());
            break;
        }
    }

    public List<MediaArtwork> getMovieArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getMovieImdbIdViaTmdbId(options.getTmdbId());
        }
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            return Collections.emptyList();
        }
        try {
            List<MediaArtwork> artworks = this.getMediaArt(options);
            if (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL) {
                return artworks;
            }
            return artworks.stream().filter(ma -> ma.getType() == options.getArtworkType()).toList();
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    public Map<String, Integer> getMovieTop250() {
        return this.parseTop250("/chart/top/");
    }
}

