/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.rating.RatingProvider;

public final class TmmModuleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmModuleManager.class);
    private static TmmModuleManager instance;
    private final Set<ITmmModule> modules = new LinkedHashSet<ITmmModule>();
    private Timer statisticsTimer;
    private boolean isActive;

    private TmmModuleManager() {
    }

    public static TmmModuleManager getInstance() {
        if (instance == null) {
            instance = new TmmModuleManager();
        }
        return instance;
    }

    static void clearInstances() {
        instance = null;
        Settings.clearInstance();
    }

    public void registerModule(ITmmModule module) {
        this.modules.add(module);
    }

    public void enableModule(ITmmModule module) throws Exception {
        if (!this.modules.contains(module)) {
            throw new Exception("module " + module.getModuleTitle() + " not registered");
        }
        module.startUp();
    }

    public void disableModule(ITmmModule module) throws Exception {
        if (!this.modules.contains(module)) {
            throw new Exception("module " + module.getModuleTitle() + " not registered");
        }
        module.shutDown();
    }

    public Set<ITmmModule> getModules() {
        return this.modules;
    }

    public void startUp() {
        this.statisticsTimer = new Timer(true);
        this.statisticsTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!TmmModuleManager.this.isActive) {
                    return;
                }
                Runtime rt = Runtime.getRuntime();
                long totalMem = rt.totalMemory();
                long maxMem = rt.maxMemory();
                long freeMem = rt.freeMemory();
                long megs = 0x100000L;
                long used = (totalMem - freeMem) / megs;
                long free = (maxMem - totalMem + freeMem) / megs;
                LOGGER.debug("Memory usage: used - {} M | free - {} M", (Object)used, (Object)free);
                TmmModuleManager.this.isActive = false;
            }
        }, 20000L, 60000L);
        this.isActive = true;
    }

    public void shutDown() {
        if (this.statisticsTimer != null) {
            this.statisticsTimer.cancel();
        }
        for (ITmmModule module : this.modules) {
            try {
                module.shutDown();
            }
            catch (Exception e) {
                LOGGER.error("Problem shutting down '{}' - {}", (Object)module.getModuleTitle(), (Object)e.getMessage());
            }
        }
        RatingProvider.shutdown();
        Utils.clearTempFolder();
    }

    public void initializeDatabase() {
        for (ITmmModule module : this.modules) {
            try {
                if (module.isEnabled()) {
                    module.shutDown();
                }
                module.initializeDatabase();
            }
            catch (Exception e) {
                LOGGER.error("Problem shutting down " + module.getModuleTitle() + ": " + e.getMessage());
            }
        }
    }

    public void saveSettings() {
        Settings.getInstance().saveSettings();
        for (ITmmModule module : this.modules) {
            try {
                if (!module.isEnabled()) continue;
                module.saveSettings();
            }
            catch (Exception e) {
                LOGGER.error("Saving settings for '{}' - '{}'", (Object)module.getModuleTitle(), (Object)e.getMessage());
            }
        }
    }

    public void setActive() {
        this.isActive = true;
    }
}

