/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.util.BigEndian;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public final class Util {
    public static int getUInt8(byte[] byArray, int n) {
        return LittleEndian.getUInt8((byte[])byArray, (int)(n - 1));
    }

    public static int getInt8(byte[] byArray, int n) {
        return LittleEndian.getInt8((byte[])byArray, (int)(n - 1));
    }

    public static int getUInt16LE(byte[] byArray, int n) {
        return LittleEndian.getUInt16((byte[])byArray, (int)(n - 1));
    }

    public static int getUInt16BE(byte[] byArray, int n) {
        return BigEndian.getUInt16((byte[])byArray, (int)(n - 1));
    }

    public static int getUInt16Both(byte[] byArray, int n) {
        return LittleEndian.getUInt16((byte[])byArray, (int)(n - 1));
    }

    public static long getUInt32LE(byte[] byArray, int n) {
        return LittleEndian.getUInt32((byte[])byArray, (int)(n - 1));
    }

    public static long getUInt32BE(byte[] byArray, int n) {
        return BigEndian.getUInt32((byte[])byArray, (int)(n - 1));
    }

    public static long getUInt32Both(byte[] byArray, int n) {
        return LittleEndian.getUInt32((byte[])byArray, (int)(n - 1));
    }

    public static String getAChars(byte[] byArray, int n, int n2) {
        return new String(byArray, n - 1, n2).trim();
    }

    public static String getDChars(byte[] byArray, int n, int n2) {
        return new String(byArray, n - 1, n2).trim();
    }

    public static String getAChars(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n - 1, n2, string).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String getDChars(byte[] byArray, int n, int n2, String string) {
        if (byArray.length >= n + n2) {
            try {
                return new String(byArray, n - 1, n2, string).trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return "";
    }

    public static byte[] getBytes(byte[] byArray, int n, int n2) {
        return Arrays.copyOfRange(byArray, n, n + n2);
    }

    public static String getString(byte[] byArray, int n, int n2) {
        return Util.getString(byArray, n, n2, "ASCII");
    }

    public static String getString(byte[] byArray, int n, int n2, String string) {
        byte[] byArray2 = Util.getBytes(byArray, n - 1, n2);
        try {
            return new String(byArray2, string).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static long getStringDate(byte[] byArray, int n) {
        int n2 = n - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Util.toInt(byArray, n2, 4));
        calendar.set(2, Util.toInt(byArray, n2 += 4, 2) - 1);
        calendar.set(5, Util.toInt(byArray, n2 += 2, 2));
        calendar.set(11, Util.toInt(byArray, n2 += 2, 2));
        calendar.set(12, Util.toInt(byArray, n2 += 2, 2));
        calendar.set(13, Util.toInt(byArray, n2 += 2, 2));
        calendar.set(14, Util.toInt(byArray, n2 += 2, 2) * 10);
        calendar.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(byArray[n2 + 2])));
        return calendar.getTimeInMillis();
    }

    private static int toInt(byte[] byArray, int n, int n2) {
        try {
            return Integer.parseInt(new String(byArray, n, n2));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static long getDateTime(byte[] byArray, int n) {
        int n2 = n - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1900 + byArray[n2]);
        calendar.set(2, byArray[n2 + 1] - 1);
        calendar.set(5, byArray[n2 + 2]);
        calendar.set(11, byArray[n2 + 3]);
        calendar.set(12, byArray[n2 + 4]);
        calendar.set(13, byArray[n2 + 5]);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone(Util.getGMTpos(byArray[n2 + 6])));
        return calendar.getTimeInMillis();
    }

    private static String getGMTpos(byte by) {
        if (0 == by) {
            return "GMT";
        }
        StringBuffer stringBuffer = new StringBuffer("GMT");
        stringBuffer.append(by < 0 ? (char)'-' : '+');
        int n = Math.abs(by) * 15;
        int n2 = n / 60;
        int n3 = n % 60;
        stringBuffer.append(n2).append(':').append(0 == n3 ? "00" : String.valueOf(n3));
        return stringBuffer.toString();
    }

    private Util() {
    }
}

