/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.AutocompleteSupport;
import org.tinymediamanager.ui.components.label.JHintLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class TvShowUiSettingsPanel
extends JPanel {
    private static final int COL_COUNT = 7;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private JCheckBox chckbxShowMissingEpisodes;
    private AutocompleteComboBox<String> cbRating;
    private JList listRatings;
    private JButton btnAddRating;
    private JButton btnRemoveRating;
    private JButton btnMoveRatingUp;
    private JButton btnMoveRatingDown;
    private JCheckBox chckbxShowMissingSpecials;
    private JCheckBox chckbxTvShowTableTooltips;
    private JCheckBox chckbxSeasonArtworkFallback;
    private JCheckBox chckbxStoreFilter;
    private JCheckBox chckbxNode;
    private JCheckBox chckbxTitle;
    private JCheckBox chckbxOriginalTitle;
    private JCheckBox chckbxEnglishTitle;
    private JCheckBox chckbxUniversalNote;
    private JCheckBox chckbxUniversalFilename;
    private JCheckBox chckbxUniversalTags;
    private JCheckBox chckbxUniversalProductionCompany;
    private JCheckBox chckbxUniversalCountry;
    private JCheckBox chckbxUniversalLanguages;
    private JCheckBox chckbxUniversalActors;
    private JCheckBox chckbxUniversalDirectors;
    private JCheckBox chckbxUniversalWriters;
    private final Map<TvShowScraperMetadataConfig, JCheckBox> tvShowMetadataCheckBoxes = new LinkedHashMap<TvShowScraperMetadataConfig, JCheckBox>();
    private final Map<TvShowEpisodeScraperMetadataConfig, JCheckBox> episodeMetadataCheckBoxes = new LinkedHashMap<TvShowEpisodeScraperMetadataConfig, JCheckBox>();
    private JCheckBox chckbxTvShowDisplayAllMissingMetadata;
    private JCheckBox chckbxEpisodeDisplayAllMissingMetadata;
    private JCheckBox chckbxEpisodeSpecialsCheckMissingMetadata;
    private final Map<TvShowScraperMetadataConfig, JCheckBox> tvShowArtworkCheckBoxes = new LinkedHashMap<TvShowScraperMetadataConfig, JCheckBox>();
    private final Map<TvShowScraperMetadataConfig, JCheckBox> seasonArtworkCheckBoxes = new LinkedHashMap<TvShowScraperMetadataConfig, JCheckBox>();
    private final Map<TvShowEpisodeScraperMetadataConfig, JCheckBox> episodeArtworkCheckBoxes = new LinkedHashMap<TvShowEpisodeScraperMetadataConfig, JCheckBox>();
    private JCheckBox chckbxTvShowDisplayAllMissingArtwork;
    private JCheckBox chckbxSeasonDisplayAllMissingArtwork;
    private JCheckBox chckbxEpisodeDisplayAllMissingArtwork;
    private JCheckBox chckbxEpisodeSpecialsCheckMissingArtwork;
    private JCheckBox chckbxTvShowPoster;
    private JCheckBox chckbxTvShowFanart;
    private JCheckBox chckbxTvShowBanner;
    private JCheckBox chckbxTvShowThumb;
    private JCheckBox chckbxTvShowClearlogo;
    private JCheckBox chckbxSeasonPoster;
    private JCheckBox chckbxEpisodePoster;
    private JCheckBox chckbxEpisodeThumb;
    private JCheckBox chckbxSeasonThumb;
    private JCheckBox chckbxSeasonBanner;
    private JCheckBox chckbxSeasonFanart;
    private JCheckBox chckbxIncludeNotAired;

    TvShowUiSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.initComponents();
        this.initDataBindings();
        this.btnAddRating.addActionListener(arg0 -> {
            String str;
            JTextField tf;
            String selectedText;
            Object selectedItem = this.cbRating.getSelectedItem();
            Component editorComponent = this.cbRating.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (selectedItem instanceof String && StringUtils.isNotBlank((CharSequence)(str = (String)selectedItem))) {
                TvShowModuleManager.getInstance().getSettings().addRatingSource(str);
                if (editorComponent instanceof JTextField) {
                    AutocompleteSupport<String> autoCompleteSupport = this.cbRating.getAutoCompleteSupport();
                    autoCompleteSupport.setFirstItem(null);
                    this.cbRating.setSelectedIndex(0);
                    autoCompleteSupport.removeFirstItem();
                }
            }
        });
        this.btnRemoveRating.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1) {
                String ratingSource = this.settings.getRatingSources().get(row);
                TvShowModuleManager.getInstance().getSettings().removeRatingSource(ratingSource);
            }
        });
        this.btnMoveRatingUp.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1 && row != 0) {
                this.settings.swapRatingSources(row, row - 1);
                this.listRatings.setSelectedIndex(--row);
                this.listRatings.updateUI();
            }
        });
        this.btnMoveRatingDown.addActionListener(arg0 -> {
            int row = this.listRatings.getSelectedIndex();
            if (row != -1 && row < this.listRatings.getModel().getSize() - 1) {
                this.settings.swapRatingSources(row, row + 1);
                this.listRatings.setSelectedIndex(++row);
                this.listRatings.updateUI();
            }
        });
        this.buildCheckBoxes();
    }

    private void checkChanges() {
        JCheckBox value;
        Enum key;
        ArrayList<MediaFileType> tvShowArtworkTypes = new ArrayList<MediaFileType>();
        if (this.chckbxTvShowPoster.isSelected()) {
            tvShowArtworkTypes.add(MediaFileType.POSTER);
        }
        if (this.chckbxTvShowFanart.isSelected()) {
            tvShowArtworkTypes.add(MediaFileType.FANART);
        }
        if (this.chckbxTvShowBanner.isSelected()) {
            tvShowArtworkTypes.add(MediaFileType.BANNER);
        }
        if (this.chckbxTvShowThumb.isSelected()) {
            tvShowArtworkTypes.add(MediaFileType.THUMB);
        }
        if (this.chckbxTvShowClearlogo.isSelected()) {
            tvShowArtworkTypes.add(MediaFileType.CLEARLOGO);
        }
        this.settings.setShowTvShowArtworkTypes(tvShowArtworkTypes);
        ArrayList<MediaFileType> seasonArtworkTypes = new ArrayList<MediaFileType>();
        if (this.chckbxSeasonPoster.isSelected()) {
            seasonArtworkTypes.add(MediaFileType.SEASON_POSTER);
        }
        if (this.chckbxSeasonFanart.isSelected()) {
            seasonArtworkTypes.add(MediaFileType.SEASON_FANART);
        }
        if (this.chckbxSeasonBanner.isSelected()) {
            seasonArtworkTypes.add(MediaFileType.SEASON_BANNER);
        }
        if (this.chckbxSeasonThumb.isSelected()) {
            seasonArtworkTypes.add(MediaFileType.SEASON_THUMB);
        }
        this.settings.setShowSeasonArtworkTypes(seasonArtworkTypes);
        ArrayList<MediaFileType> episodeArtworkTypes = new ArrayList<MediaFileType>();
        if (this.chckbxEpisodePoster.isSelected()) {
            episodeArtworkTypes.add(MediaFileType.SEASON_POSTER);
        }
        if (this.chckbxEpisodeThumb.isSelected()) {
            episodeArtworkTypes.add(MediaFileType.THUMB);
        }
        this.settings.setShowEpisodeArtworkTypes(episodeArtworkTypes);
        ArrayList<AbstractSettings.UniversalFilterFields> universalFilterFields = new ArrayList<AbstractSettings.UniversalFilterFields>();
        if (this.chckbxUniversalNote.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.NOTE);
        }
        if (this.chckbxUniversalFilename.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.FILENAME);
        }
        if (this.chckbxUniversalTags.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.TAGS);
        }
        if (this.chckbxUniversalCountry.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.COUNTRY);
        }
        if (this.chckbxUniversalProductionCompany.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.PRODUCTION_COMPANY);
        }
        if (this.chckbxUniversalLanguages.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.SPOKEN_LANGUAGE);
        }
        if (this.chckbxUniversalActors.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.ACTOR);
        }
        if (this.chckbxUniversalWriters.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.WRITER);
        }
        if (this.chckbxUniversalDirectors.isSelected()) {
            universalFilterFields.add(AbstractSettings.UniversalFilterFields.DIRECTOR);
        }
        this.settings.setUniversalFilterFields(universalFilterFields);
        this.settings.clearTvShowCheckMetadata();
        for (Map.Entry<TvShowScraperMetadataConfig, JCheckBox> entry : this.tvShowMetadataCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addTvShowCheckMetadata((TvShowScraperMetadataConfig)key);
        }
        this.settings.clearTvShowCheckArtwork();
        for (Map.Entry<TvShowScraperMetadataConfig, JCheckBox> entry : this.tvShowArtworkCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addTvShowCheckArtwork((TvShowScraperMetadataConfig)key);
        }
        this.settings.clearSeasonCheckArtwork();
        for (Map.Entry<TvShowScraperMetadataConfig, JCheckBox> entry : this.seasonArtworkCheckBoxes.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addSeasonCheckArtwork((TvShowScraperMetadataConfig)key);
        }
        this.settings.clearEpisodeCheckMetadata();
        for (Map.Entry<Enum, JCheckBox> entry : this.episodeMetadataCheckBoxes.entrySet()) {
            key = (TvShowEpisodeScraperMetadataConfig)entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addEpisodeCheckMetadata((TvShowEpisodeScraperMetadataConfig)key);
        }
        this.settings.clearEpisodeCheckArtwork();
        for (Map.Entry<Enum, JCheckBox> entry : this.episodeArtworkCheckBoxes.entrySet()) {
            key = (TvShowEpisodeScraperMetadataConfig)entry.getKey();
            value = entry.getValue();
            if (!value.isSelected()) continue;
            this.settings.addEpisodeCheckArtwork((TvShowEpisodeScraperMetadataConfig)key);
        }
    }

    private void buildCheckBoxes() {
        JCheckBox checkBox;
        for (MediaFileType mediaFileType : this.settings.getShowTvShowArtworkTypes()) {
            switch (mediaFileType) {
                case POSTER: {
                    this.chckbxTvShowPoster.setSelected(true);
                    break;
                }
                case FANART: {
                    this.chckbxTvShowFanart.setSelected(true);
                    break;
                }
                case BANNER: {
                    this.chckbxTvShowBanner.setSelected(true);
                    break;
                }
                case THUMB: {
                    this.chckbxTvShowThumb.setSelected(true);
                    break;
                }
                case CLEARLOGO: {
                    this.chckbxTvShowClearlogo.setSelected(true);
                }
            }
        }
        for (MediaFileType mediaFileType : this.settings.getShowSeasonArtworkTypes()) {
            switch (mediaFileType) {
                case POSTER: 
                case SEASON_POSTER: {
                    this.chckbxSeasonPoster.setSelected(true);
                    break;
                }
                case FANART: 
                case SEASON_FANART: {
                    this.chckbxSeasonFanart.setSelected(true);
                    break;
                }
                case BANNER: 
                case SEASON_BANNER: {
                    this.chckbxSeasonBanner.setSelected(true);
                    break;
                }
                case THUMB: 
                case SEASON_THUMB: {
                    this.chckbxSeasonThumb.setSelected(true);
                }
            }
        }
        for (MediaFileType mediaFileType : this.settings.getShowEpisodeArtworkTypes()) {
            switch (mediaFileType) {
                case POSTER: 
                case SEASON_POSTER: {
                    this.chckbxEpisodePoster.setSelected(true);
                    break;
                }
                case THUMB: {
                    this.chckbxEpisodeThumb.setSelected(true);
                }
            }
        }
        for (AbstractSettings.UniversalFilterFields universalFilterFields : this.settings.getUniversalFilterFields()) {
            switch (universalFilterFields) {
                case NOTE: {
                    this.chckbxUniversalNote.setSelected(true);
                    break;
                }
                case FILENAME: {
                    this.chckbxUniversalFilename.setSelected(true);
                    break;
                }
                case TAGS: {
                    this.chckbxUniversalTags.setSelected(true);
                    break;
                }
                case PRODUCTION_COMPANY: {
                    this.chckbxUniversalProductionCompany.setSelected(true);
                    break;
                }
                case COUNTRY: {
                    this.chckbxUniversalCountry.setSelected(true);
                    break;
                }
                case SPOKEN_LANGUAGE: {
                    this.chckbxUniversalLanguages.setSelected(true);
                    break;
                }
                case ACTOR: {
                    this.chckbxUniversalActors.setSelected(true);
                    break;
                }
                case DIRECTOR: {
                    this.chckbxUniversalDirectors.setSelected(true);
                    break;
                }
                case WRITER: {
                    this.chckbxUniversalWriters.setSelected(true);
                }
            }
        }
        this.chckbxTvShowPoster.addItemListener(this.checkBoxListener);
        this.chckbxTvShowFanart.addItemListener(this.checkBoxListener);
        this.chckbxTvShowBanner.addItemListener(this.checkBoxListener);
        this.chckbxTvShowThumb.addItemListener(this.checkBoxListener);
        this.chckbxTvShowClearlogo.addItemListener(this.checkBoxListener);
        this.chckbxSeasonPoster.addItemListener(this.checkBoxListener);
        this.chckbxSeasonFanart.addItemListener(this.checkBoxListener);
        this.chckbxSeasonBanner.addItemListener(this.checkBoxListener);
        this.chckbxSeasonThumb.addItemListener(this.checkBoxListener);
        this.chckbxEpisodePoster.addItemListener(this.checkBoxListener);
        this.chckbxEpisodeThumb.addItemListener(this.checkBoxListener);
        this.chckbxUniversalNote.addItemListener(this.checkBoxListener);
        this.chckbxUniversalFilename.addItemListener(this.checkBoxListener);
        this.chckbxUniversalTags.addItemListener(this.checkBoxListener);
        this.chckbxUniversalProductionCompany.addItemListener(this.checkBoxListener);
        this.chckbxUniversalCountry.addItemListener(this.checkBoxListener);
        this.chckbxUniversalLanguages.addItemListener(this.checkBoxListener);
        this.chckbxUniversalActors.addItemListener(this.checkBoxListener);
        this.chckbxUniversalDirectors.addItemListener(this.checkBoxListener);
        this.chckbxUniversalWriters.addItemListener(this.checkBoxListener);
        for (TvShowScraperMetadataConfig tvShowScraperMetadataConfig : this.settings.getTvShowCheckMetadata()) {
            checkBox = this.tvShowMetadataCheckBoxes.get(tvShowScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.tvShowMetadataCheckBoxes.values()) {
            jCheckBox.addItemListener(this.checkBoxListener);
        }
        for (TvShowScraperMetadataConfig tvShowScraperMetadataConfig : this.settings.getTvShowCheckArtwork()) {
            checkBox = this.tvShowArtworkCheckBoxes.get(tvShowScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.tvShowArtworkCheckBoxes.values()) {
            jCheckBox.addItemListener(this.checkBoxListener);
        }
        for (TvShowScraperMetadataConfig tvShowScraperMetadataConfig : this.settings.getSeasonCheckArtwork()) {
            checkBox = this.seasonArtworkCheckBoxes.get(tvShowScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.seasonArtworkCheckBoxes.values()) {
            jCheckBox.addItemListener(this.checkBoxListener);
        }
        for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : this.settings.getEpisodeCheckMetadata()) {
            checkBox = this.episodeMetadataCheckBoxes.get(tvShowEpisodeScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.episodeMetadataCheckBoxes.values()) {
            jCheckBox.addItemListener(this.checkBoxListener);
        }
        for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : this.settings.getEpisodeCheckArtwork()) {
            checkBox = this.episodeArtworkCheckBoxes.get(tvShowEpisodeScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.episodeArtworkCheckBoxes.values()) {
            jCheckBox.addItemListener(this.checkBoxListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        void var12_25;
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][]"));
        JPanel panelUiSettings = new JPanel();
        panelUiSettings.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][10lp!][][grow][10lp!][][grow][10lp!][]"));
        TmmLabel lblUiSettings = new TmmLabel(TmmResourceBundle.getString("Settings.ui"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettings, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#ui-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        JLabel lblNewLabel = new JLabel(TmmResourceBundle.getString("Settings.showartworktypes"));
        panelUiSettings.add((Component)lblNewLabel, "cell 1 0 2 1");
        JPanel panelShowArtwork = new JPanel();
        panelUiSettings.add((Component)panelShowArtwork, "cell 2 1,grow");
        panelShowArtwork.setLayout((LayoutManager)new MigLayout("", "[][][][][][]", "[][][]"));
        JLabel lblTvShowArtwork = new JLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelShowArtwork.add((Component)lblTvShowArtwork, "flowy,cell 0 0");
        this.chckbxTvShowPoster = new JCheckBox(TmmResourceBundle.getString("mediafiletype.poster"));
        panelShowArtwork.add((Component)this.chckbxTvShowPoster, "cell 1 0");
        this.chckbxTvShowFanart = new JCheckBox(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelShowArtwork.add((Component)this.chckbxTvShowFanart, "cell 2 0");
        this.chckbxTvShowBanner = new JCheckBox(TmmResourceBundle.getString("mediafiletype.banner"));
        panelShowArtwork.add((Component)this.chckbxTvShowBanner, "cell 3 0");
        this.chckbxTvShowThumb = new JCheckBox(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelShowArtwork.add((Component)this.chckbxTvShowThumb, "cell 4 0");
        this.chckbxTvShowClearlogo = new JCheckBox(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        panelShowArtwork.add((Component)this.chckbxTvShowClearlogo, "cell 5 0");
        JLabel lblSeasonArtwork = new JLabel(TmmResourceBundle.getString("metatag.season"));
        panelShowArtwork.add((Component)lblSeasonArtwork, "flowy,cell 0 1");
        this.chckbxSeasonPoster = new JCheckBox(TmmResourceBundle.getString("mediafiletype.poster"));
        panelShowArtwork.add((Component)this.chckbxSeasonPoster, "cell 1 1");
        this.chckbxSeasonFanart = new JCheckBox(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelShowArtwork.add((Component)this.chckbxSeasonFanart, "cell 2 1");
        this.chckbxSeasonBanner = new JCheckBox(TmmResourceBundle.getString("mediafiletype.banner"));
        panelShowArtwork.add((Component)this.chckbxSeasonBanner, "cell 3 1");
        this.chckbxSeasonThumb = new JCheckBox(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelShowArtwork.add((Component)this.chckbxSeasonThumb, "cell 4 1");
        TvShowScraperMetadataConfig[] lblEpisodeArtwork = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        panelShowArtwork.add((Component)lblEpisodeArtwork, "cell 0 2");
        this.chckbxEpisodePoster = new JCheckBox(TmmResourceBundle.getString("mediafiletype.season_poster"));
        panelShowArtwork.add((Component)this.chckbxEpisodePoster, "cell 1 2");
        this.chckbxEpisodeThumb = new JCheckBox(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelShowArtwork.add((Component)this.chckbxEpisodeThumb, "cell 2 2");
        this.chckbxSeasonArtworkFallback = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.seasonartworkfallback"));
        panelUiSettings.add((Component)this.chckbxSeasonArtworkFallback, "cell 1 2 2 1");
        this.chckbxShowMissingEpisodes = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.missingepisodes"));
        panelUiSettings.add((Component)this.chckbxShowMissingEpisodes, "cell 1 3 2 1");
        this.chckbxShowMissingSpecials = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.missingespecials"));
        panelUiSettings.add((Component)this.chckbxShowMissingSpecials, "cell 2 4");
        this.chckbxIncludeNotAired = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.missingnotaired"));
        panelUiSettings.add((Component)this.chckbxIncludeNotAired, "cell 2 5");
        this.chckbxTvShowTableTooltips = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.showtabletooltips"));
        panelUiSettings.add((Component)this.chckbxTvShowTableTooltips, "cell 1 6 2 1");
        JLabel lblCheckMetadata = new JLabel(TmmResourceBundle.getString("Settings.checkmetadata"));
        panelUiSettings.add((Component)lblCheckMetadata, "cell 1 8 2 1");
        JPanel panelCheckMetadata = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        TmmLabel lblTvShow = new TmmLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelCheckMetadata.add((Component)lblTvShow, gbc.clone());
        ++gbc.gridx;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isMetaData()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, value, this.tvShowMetadataCheckBoxes, gbc);
        }
        gbc.gridx = 1;
        ++gbc.gridy;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isCast()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, value, this.tvShowMetadataCheckBoxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        panelCheckMetadata.add(Box.createVerticalStrut(5), gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxTvShowDisplayAllMissingMetadata = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkmetadata.displayall"));
        this.chckbxTvShowDisplayAllMissingMetadata.setToolTipText(TmmResourceBundle.getString("Settings.checkmetadata.displayall.desc"));
        panelCheckMetadata.add((Component)this.chckbxTvShowDisplayAllMissingMetadata, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        panelCheckMetadata.add(Box.createVerticalStrut(10), gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        TvShowScraperMetadataConfig[] lblEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        panelCheckMetadata.add((Component)lblEpisode, gbc.clone());
        ++gbc.gridx;
        for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : TvShowEpisodeScraperMetadataConfig.values()) {
            if (!tvShowEpisodeScraperMetadataConfig.isMetaData()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, tvShowEpisodeScraperMetadataConfig, this.episodeMetadataCheckBoxes, gbc);
        }
        gbc.gridx = 1;
        ++gbc.gridy;
        TvShowEpisodeScraperMetadataConfig[] tvShowEpisodeScraperMetadataConfigArray = TvShowEpisodeScraperMetadataConfig.values();
        int n = tvShowEpisodeScraperMetadataConfigArray.length;
        for (int value = 0; value < n; ++value) {
            TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig = tvShowEpisodeScraperMetadataConfigArray[value];
            if (!tvShowEpisodeScraperMetadataConfig.isCast()) continue;
            this.addMetadataCheckbox(panelCheckMetadata, tvShowEpisodeScraperMetadataConfig, this.episodeMetadataCheckBoxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        panelCheckMetadata.add(Box.createVerticalStrut(5), gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxEpisodeDisplayAllMissingMetadata = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkmetadata.displayall"));
        this.chckbxEpisodeDisplayAllMissingMetadata.setToolTipText(TmmResourceBundle.getString("Settings.checkmetadata.displayall.desc"));
        panelCheckMetadata.add((Component)this.chckbxEpisodeDisplayAllMissingMetadata, gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxEpisodeSpecialsCheckMissingMetadata = new JCheckBox(TmmResourceBundle.getString("tvshowepisode.checkmetadata.specials"));
        panelCheckMetadata.add((Component)this.chckbxEpisodeSpecialsCheckMissingMetadata, gbc.clone());
        panelUiSettings.add((Component)panelCheckMetadata, "cell 2 9");
        JLabel lblCheckArtwork = new JLabel(TmmResourceBundle.getString("Settings.checkimages"));
        panelUiSettings.add((Component)lblCheckArtwork, "cell 1 11 2 1");
        JPanel panelCheckArtwork = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        lblTvShow = new TmmLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelCheckArtwork.add((Component)lblTvShow, gbc.clone());
        ++gbc.gridx;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isArtwork() || value.name().startsWith("SEASON_")) continue;
            this.addMetadataCheckbox(panelCheckArtwork, value, this.tvShowArtworkCheckBoxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        panelCheckArtwork.add(Box.createVerticalStrut(5), gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxTvShowDisplayAllMissingArtwork = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkimages.displayall"));
        this.chckbxTvShowDisplayAllMissingArtwork.setToolTipText(TmmResourceBundle.getString("Settings.checkimages.displayall.desc"));
        panelCheckArtwork.add((Component)this.chckbxTvShowDisplayAllMissingArtwork, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        panelCheckArtwork.add(Box.createVerticalStrut(10), gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        TmmLabel lblSeason = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        panelCheckArtwork.add((Component)lblSeason, gbc.clone());
        ++gbc.gridx;
        for (TvShowScraperMetadataConfig tvShowScraperMetadataConfig : TvShowScraperMetadataConfig.values()) {
            if (!tvShowScraperMetadataConfig.isArtwork() || !tvShowScraperMetadataConfig.name().startsWith("SEASON_")) continue;
            this.addMetadataCheckbox(panelCheckArtwork, tvShowScraperMetadataConfig, this.seasonArtworkCheckBoxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        panelCheckArtwork.add(Box.createVerticalStrut(5), gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxSeasonDisplayAllMissingArtwork = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkimages.displayall"));
        this.chckbxSeasonDisplayAllMissingArtwork.setToolTipText(TmmResourceBundle.getString("Settings.checkimages.displayall.desc"));
        panelCheckArtwork.add((Component)this.chckbxSeasonDisplayAllMissingArtwork, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        panelCheckArtwork.add(Box.createVerticalStrut(10), gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        TmmLabel lblEpisode2 = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        panelCheckArtwork.add((Component)lblEpisode2, gbc.clone());
        ++gbc.gridx;
        TvShowEpisodeScraperMetadataConfig[] tvShowEpisodeScraperMetadataConfigArray2 = TvShowEpisodeScraperMetadataConfig.values();
        int n2 = tvShowEpisodeScraperMetadataConfigArray2.length;
        boolean bl = false;
        while (var12_25 < n2) {
            TvShowEpisodeScraperMetadataConfig value = tvShowEpisodeScraperMetadataConfigArray2[var12_25];
            if (value.isArtwork()) {
                this.addMetadataCheckbox(panelCheckArtwork, value, this.episodeArtworkCheckBoxes, gbc);
            }
            ++var12_25;
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        panelCheckArtwork.add(Box.createVerticalStrut(5), gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxEpisodeDisplayAllMissingArtwork = new JHintCheckBox(TmmResourceBundle.getString("Settings.checkimages.displayall"));
        this.chckbxEpisodeDisplayAllMissingArtwork.setToolTipText(TmmResourceBundle.getString("Settings.checkimages.displayall.desc"));
        panelCheckArtwork.add((Component)this.chckbxEpisodeDisplayAllMissingArtwork, gbc.clone());
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 7;
        this.chckbxEpisodeSpecialsCheckMissingArtwork = new JCheckBox(TmmResourceBundle.getString("tvshowepisode.checkartwork.specials"));
        panelCheckArtwork.add((Component)this.chckbxEpisodeSpecialsCheckMissingArtwork, gbc.clone());
        panelUiSettings.add((Component)panelCheckArtwork, "cell 2 12");
        JLabel lblRating = new JLabel(TmmResourceBundle.getString("Settings.preferredrating"));
        panelUiSettings.add((Component)lblRating, "cell 1 14 2 1");
        JPanel panelRatingSource = new JPanel();
        panelUiSettings.add((Component)panelRatingSource, "cell 2 15,grow");
        panelRatingSource.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp][]", "[grow][]"));
        this.listRatings = new JList();
        this.listRatings.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.listRatings);
        panelRatingSource.add((Component)scrollPane, "cell 0 0,grow");
        this.btnMoveRatingUp = new SquareIconButton(IconManager.ARROW_UP_INV);
        this.btnMoveRatingUp.setToolTipText(TmmResourceBundle.getString("Button.moveup"));
        panelRatingSource.add((Component)this.btnMoveRatingUp, "flowy,cell 1 0,aligny bottom");
        this.btnMoveRatingDown = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        this.btnMoveRatingDown.setToolTipText(TmmResourceBundle.getString("Button.movedown"));
        panelRatingSource.add((Component)this.btnMoveRatingDown, "cell 1 0,aligny bottom");
        this.cbRating = new AutocompleteComboBox<String>(Arrays.asList("tvdb", "tmdb", "imdb", "trakt", "metascore", "rottenTomatoes", "anidb"));
        panelRatingSource.add(this.cbRating, "cell 0 1,growx");
        this.btnRemoveRating = new SquareIconButton(IconManager.REMOVE_INV);
        this.btnRemoveRating.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        panelRatingSource.add((Component)this.btnRemoveRating, "cell 1 0");
        this.btnAddRating = new SquareIconButton(IconManager.ADD_INV);
        this.btnAddRating.setToolTipText(TmmResourceBundle.getString("Button.add"));
        panelRatingSource.add((Component)this.btnAddRating, "cell 1 1");
        JPanel panelFilter = new JPanel();
        panelFilter.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][10lp!][]"));
        TmmLabel lblAutomaticTasksT = new TmmLabel(TmmResourceBundle.getString("Settings.filters"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelFilter, lblAutomaticTasksT, true);
        JLabel lblTvShowFilter = new JLabel(TmmResourceBundle.getString("Settings.tvshowquickfilter"));
        panelFilter.add((Component)lblTvShowFilter, "cell 1 0 2 1");
        this.chckbxNode = new JCheckBox(TmmResourceBundle.getString("metatag.node"));
        panelFilter.add((Component)this.chckbxNode, "flowx,cell 2 1");
        this.chckbxTitle = new JCheckBox(TmmResourceBundle.getString("metatag.title"));
        panelFilter.add((Component)this.chckbxTitle, "cell 2 1");
        this.chckbxOriginalTitle = new JCheckBox(TmmResourceBundle.getString("metatag.originaltitle"));
        panelFilter.add((Component)this.chckbxOriginalTitle, "cell 2 1");
        this.chckbxEnglishTitle = new JCheckBox(TmmResourceBundle.getString("metatag.title.english"));
        panelFilter.add((Component)this.chckbxEnglishTitle, "cell 2 1");
        JHintLabel lblUniversalFilter = new JHintLabel(TmmResourceBundle.getString("filter.universal"));
        panelFilter.add((Component)lblUniversalFilter, "cell 1 2 2 1");
        lblUniversalFilter.setHintIcon(IconManager.HINT);
        lblUniversalFilter.setToolTipText(TmmResourceBundle.getString("filter.universal.hint"));
        this.chckbxUniversalNote = new JCheckBox(TmmResourceBundle.getString("metatag.note"));
        panelFilter.add((Component)this.chckbxUniversalNote, "flowx,cell 2 3");
        this.chckbxUniversalFilename = new JCheckBox(TmmResourceBundle.getString("metatag.filename"));
        panelFilter.add((Component)this.chckbxUniversalFilename, "cell 2 3");
        this.chckbxUniversalTags = new JCheckBox(TmmResourceBundle.getString("metatag.tags"));
        panelFilter.add((Component)this.chckbxUniversalTags, "cell 2 3");
        this.chckbxUniversalProductionCompany = new JCheckBox(TmmResourceBundle.getString("metatag.production"));
        panelFilter.add((Component)this.chckbxUniversalProductionCompany, "cell 2 3");
        this.chckbxUniversalCountry = new JCheckBox(TmmResourceBundle.getString("metatag.country"));
        panelFilter.add((Component)this.chckbxUniversalCountry, "cell 2 3");
        this.chckbxUniversalLanguages = new JCheckBox(TmmResourceBundle.getString("metatag.spokenlanguages"));
        panelFilter.add((Component)this.chckbxUniversalLanguages, "cell 2 3");
        this.chckbxUniversalActors = new JCheckBox(TmmResourceBundle.getString("metatag.actors"));
        panelFilter.add((Component)this.chckbxUniversalActors, "flowx,cell 2 4");
        this.chckbxUniversalDirectors = new JCheckBox(TmmResourceBundle.getString("metatag.directors"));
        panelFilter.add((Component)this.chckbxUniversalDirectors, "cell 2 4");
        this.chckbxUniversalWriters = new JCheckBox(TmmResourceBundle.getString("metatag.writers"));
        panelFilter.add((Component)this.chckbxUniversalWriters, "cell 2 4");
        this.chckbxStoreFilter = new JCheckBox(TmmResourceBundle.getString("Settings.movie.persistuifilter"));
        panelFilter.add((Component)this.chckbxStoreFilter, "cell 1 6 2 1");
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#filters"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
    }

    private <E extends ScraperMetadataConfig> void addMetadataCheckbox(JPanel panel, E config, Map<E, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 1;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc.clone());
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"displayMissingEpisodes");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxShowMissingEpisodes, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"ratingSources");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (JList)this.listRatings);
        jListBinding.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxShowMissingEpisodes, (Property)jCheckBoxBeanProperty, (Object)this.chckbxShowMissingSpecials, (Property)jCheckBoxBeanProperty_1);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"displayMissingSpecials");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxShowMissingSpecials, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"showTvShowTableTooltips");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxTvShowTableTooltips, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"storeUiFilters");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxStoreFilter, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty_21 = BeanProperty.create((String)"node");
        AutoBinding autoBinding_21 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_21, (Object)this.chckbxNode, (Property)jCheckBoxBeanProperty);
        autoBinding_21.bind();
        BeanProperty tvShowSettingsBeanProperty_22 = BeanProperty.create((String)"title");
        AutoBinding autoBinding_22 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_22, (Object)this.chckbxTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_22.bind();
        BeanProperty tvShowSettingsBeanProperty_23 = BeanProperty.create((String)"originalTitle");
        AutoBinding autoBinding_23 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_23, (Object)this.chckbxOriginalTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_23.bind();
        BeanProperty tvShowSettingsBeanProperty_24 = BeanProperty.create((String)"englishTitle");
        AutoBinding autoBinding_24 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_24, (Object)this.chckbxEnglishTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_24.bind();
        BeanProperty tvShowSettingsBeanProperty_15 = BeanProperty.create((String)"tvShowDisplayAllMissingMetadata");
        AutoBinding autoBinding_25 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_15, (Object)this.chckbxTvShowDisplayAllMissingMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_25.bind();
        BeanProperty tvShowSettingsBeanProperty_16 = BeanProperty.create((String)"episodeDisplayAllMissingMetadata");
        AutoBinding autoBinding_26 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_16, (Object)this.chckbxEpisodeDisplayAllMissingMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_26.bind();
        BeanProperty tvShowSettingsBeanProperty_17 = BeanProperty.create((String)"tvShowDisplayAllMissingArtwork");
        AutoBinding autoBinding_27 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_17, (Object)this.chckbxTvShowDisplayAllMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_27.bind();
        BeanProperty tvShowSettingsBeanProperty_18 = BeanProperty.create((String)"seasonDisplayAllMissingArtwork");
        AutoBinding autoBinding_28 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_18, (Object)this.chckbxSeasonDisplayAllMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_28.bind();
        BeanProperty tvShowSettingsBeanProperty_19 = BeanProperty.create((String)"episodeDisplayAllMissingArtwork");
        AutoBinding autoBinding_29 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_19, (Object)this.chckbxEpisodeDisplayAllMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_29.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"episodeSpecialsCheckMissingMetadata");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxEpisodeSpecialsCheckMissingMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowSettingsBeanProperty_30 = BeanProperty.create((String)"episodeSpecialsCheckMissingArtwork");
        AutoBinding autoBinding_30 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_30, (Object)this.chckbxEpisodeSpecialsCheckMissingArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_30.bind();
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxShowMissingEpisodes, (Property)jCheckBoxBeanProperty, (Object)this.chckbxIncludeNotAired, (Property)jCheckBoxBeanProperty_1);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"displayMissingNotAired");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxIncludeNotAired, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_14 = BeanProperty.create((String)"seasonArtworkFallback");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_14, (Object)this.chckbxSeasonArtworkFallback, (Property)jCheckBoxBeanProperty);
        autoBinding_19.bind();
    }
}

