/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public abstract class AbstractNumberTvShowUIFilter
extends AbstractTvShowUIFilter {
    protected JSpinner spinnerLow;
    protected JSpinner spinnerHigh;
    protected JLabel lblTo;

    protected JSpinner.NumberEditor prepareNumberEditor(JSpinner spinner, String pattern) {
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(spinner, pattern);
        numberEditor.getTextField().setColumns((int)Math.floor((float)pattern.length() * 0.8f));
        return numberEditor;
    }

    @Override
    protected JComponent createFilterComponent() {
        JPanel panelFilterComponent = new JPanel((LayoutManager)new MigLayout("insets 0", "[][][]", "[]"));
        this.spinnerLow = new JSpinner(this.getNumberModel());
        this.spinnerLow.addChangeListener(this.changeListener);
        panelFilterComponent.add((Component)this.spinnerLow, "cell 0 0");
        this.lblTo = new JLabel("-");
        panelFilterComponent.add((Component)this.lblTo, "cell 1 0");
        this.spinnerHigh = new JSpinner(this.getNumberModel());
        this.spinnerHigh.addChangeListener(this.changeListener);
        panelFilterComponent.add((Component)this.spinnerHigh, "cell 2 0");
        return panelFilterComponent;
    }

    @Override
    public String getFilterValueAsString() {
        return this.spinnerLow.getValue() + "," + this.spinnerHigh.getValue();
    }

    @Override
    public void setFilterValue(Object value) {
        String[] values = value.toString().split(",");
        if (values.length > 0) {
            this.spinnerLow.setValue(MetadataUtil.parseInt(values[0], 0));
        }
        if (values.length > 1) {
            this.spinnerHigh.setValue(MetadataUtil.parseInt(values[1], 0));
        }
    }

    @Override
    public void clearFilter() {
        this.spinnerLow.setValue(0);
        this.spinnerHigh.setValue(0);
    }

    protected abstract SpinnerNumberModel getNumberModel();

    @Override
    protected JComboBox<ITmmUIFilter.FilterOption> createOptionComboBox() {
        JComboBox<ITmmUIFilter.FilterOption> comboBox = new JComboBox<ITmmUIFilter.FilterOption>(new ITmmUIFilter.FilterOption[]{ITmmUIFilter.FilterOption.LT, ITmmUIFilter.FilterOption.LE, ITmmUIFilter.FilterOption.EQ, ITmmUIFilter.FilterOption.GT, ITmmUIFilter.FilterOption.GE, ITmmUIFilter.FilterOption.BT});
        comboBox.addActionListener(l -> {
            this.lblTo.setVisible(comboBox.getSelectedItem() == ITmmUIFilter.FilterOption.BT);
            this.spinnerHigh.setVisible(comboBox.getSelectedItem() == ITmmUIFilter.FilterOption.BT);
        });
        comboBox.setSelectedItem((Object)ITmmUIFilter.FilterOption.EQ);
        return comboBox;
    }

    protected boolean matchInt(int value) {
        ITmmUIFilter.FilterOption filterOption = this.getFilterOption();
        int low = (Integer)this.spinnerLow.getValue();
        int high = (Integer)this.spinnerHigh.getValue();
        if (value == 0) {
            return false;
        }
        if (filterOption == ITmmUIFilter.FilterOption.EQ && value == low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.LT && value < low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.LE && value <= low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.GE && value >= low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.GT && value > low) {
            return true;
        }
        return filterOption == ITmmUIFilter.FilterOption.BT && low <= value && value <= high;
    }
}

