/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieCountSubtitleFilter
extends AbstractCheckComboBoxMovieUIFilter<Integer> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieCountSubtitleFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildCountSubtitleArray();
        this.movieList.addPropertyChangeListener("countSubtitles", evt -> SwingUtilities.invokeLater(this::buildCountSubtitleArray));
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitles"));
    }

    @Override
    public String getId() {
        return "movieCountSubtitle";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaFile> mediaFileList = movie.getMediaFiles(MediaFileType.VIDEO);
        for (MediaFile mf : mediaFileList) {
            if (selectedItems.isEmpty() && mf.getSubtitles().isEmpty()) {
                return true;
            }
            if (!selectedItems.contains(mf.getSubtitles().size())) continue;
            return true;
        }
        return false;
    }

    private void buildCountSubtitleArray() {
        ArrayList<Integer> subtitles = new ArrayList<Integer>(this.movieList.getSubtitlesInMovies());
        Collections.sort(subtitles);
        this.setValues(subtitles);
    }
}

