/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.Text;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.UIManager;
import org.tinymediamanager.ui.images.SvgIconHelper;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class MediaInfoIcon
extends TmmSvgIcon {
    private static final String BASE_PATH = "/org/tinymediamanager/ui/images/mediainfo/";

    public MediaInfoIcon(String relativePath) throws Exception {
        this.setSvgURI(this.getFileUri(relativePath));
        this.setAutosize(2);
        this.setPreferredSize(new Dimension(28, 28));
        this.setColor(UIManager.getColor("Label.foreground"), "#000000");
    }

    protected URI getFileUri(String relativePath) throws Exception {
        return ((Object)((Object)this)).getClass().getResource(BASE_PATH + relativePath).toURI();
    }

    protected void setText(String text, int x) {
        try {
            this.getSvgUniverse().clear();
            SVGDiagram diagram = this.getSvgUniverse().getDiagram(this.getSvgURI());
            Text textElement = (Text)diagram.getElement("text");
            if (textElement != null) {
                textElement.addAttribute("x", 1, String.valueOf(x));
                textElement.appendText(text);
                SvgIconHelper.setFill(SvgIconHelper.getHexString(UIManager.getColor("Label.foreground")), (SVGElement)diagram.getRoot());
                textElement.rebuild();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

