/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.BindingGroup;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public abstract class TmmDialog
extends JDialog
implements IModalPopupPanelProvider {
    private final Stack<Component> focusedComponents = new Stack();
    protected BindingGroup bindingGroup = null;
    protected JPanel topPanel = null;
    protected JPanel bottomPanel = null;
    protected JPanel buttonPanel = null;
    private int popupIndex = JLayeredPane.MODAL_LAYER;

    public TmmDialog(String title, String id) {
        this(MainWindow.getInstance(), title, id);
    }

    public TmmDialog(JFrame owner, String title, String id) {
        super(owner);
        this.init(title, id);
    }

    public TmmDialog(JDialog owner, String title, String id) {
        super(owner);
        this.init(title, id);
    }

    public TmmDialog(Window owner, String title, String id) {
        super(owner);
        this.init(title, id);
    }

    protected void init(String title, String id) {
        this.setTitle(title);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.setName(id);
        }
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        if (this.getOwner() != null) {
            try {
                this.setIconImage(this.getOwner().getIconImages().get(0));
            }
            catch (Exception ignored) {
                this.setIconImage(MainWindow.LOGOS);
            }
        } else {
            this.setIconImage(MainWindow.LOGOS);
        }
        this.initBottomPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (Component component : TmmDialog.this.getLayeredPane().getComponents()) {
                    int layer = TmmDialog.this.getLayeredPane().getLayer(component);
                    if (layer < JLayeredPane.MODAL_LAYER) continue;
                    component.setBounds(TmmDialog.this.getContentPane().getBounds());
                }
            }
        });
    }

    protected void initBottomPanel() {
        this.bottomPanel = new JPanel();
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout((LayoutManager)new MigLayout("insets n 0 0 0, gap rel 0", "[grow][]", "[shrink 0][]"));
        JSeparator separator = new JSeparator();
        this.bottomPanel.add((Component)separator, "cell 0 0 2 1,growx");
        this.buttonPanel = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        this.buttonPanel.setLayout(layout);
        this.buttonPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.bottomPanel.add((Component)this.buttonPanel, "cell 1 1");
    }

    protected void setBottomPanel(JPanel panel) {
        this.getContentPane().add((Component)panel, "South");
        this.getRootPane().setDefaultButton(null);
    }

    protected void setBottomInformationPanel(JPanel panel) {
        this.bottomPanel.add((Component)panel, "cell 0 1,growx, wmin 0");
    }

    protected void setTopPanel(JPanel panel) {
        this.getContentPane().add((Component)panel, "North");
    }

    protected void setTopInformationPanel(JPanel panel) {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.getContentPane().add((Component)this.topPanel, "North");
            this.topPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 n 0, gap rel 0", "[grow]", "[][shrink 0]"));
            JSeparator separator = new JSeparator();
            this.topPanel.add((Component)separator, "cell 0 1,growx, wmin 0");
        }
        this.topPanel.add((Component)panel, "cell 0 0,growx");
    }

    private void addButton(JButton button, boolean defaultButton) {
        if (button != null) {
            this.buttonPanel.add(button);
            if (defaultButton) {
                this.getRootPane().setDefaultButton(button);
            }
        }
    }

    protected void addButton(JButton button) {
        this.addButton(button, false);
    }

    protected void addDefaultButton(JButton button) {
        this.addButton(button, true);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = super.createRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TmmDialog.this.popupIndex > JLayeredPane.MODAL_LAYER) {
                    Component[] components;
                    for (Component component : components = TmmDialog.this.getLayeredPane().getComponentsInLayer(TmmDialog.this.popupIndex - 1)) {
                        if (!(component instanceof ModalPopupPanel)) continue;
                        ModalPopupPanel popupPanel = (ModalPopupPanel)component;
                        TmmDialog.this.hideModalPopupPanel(popupPanel);
                    }
                } else {
                    TmmDialog.this.setVisible(false);
                }
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", actionListener);
        return rootPane;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            TmmUILayoutStore.getInstance().loadSettings(this);
            super.setVisible(true);
            this.toFront();
        } else {
            TmmUILayoutStore.getInstance().saveSettings(this);
            super.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.unbind();
        super.dispose();
    }

    protected void unbind() {
        if (this.bindingGroup != null) {
            try {
                this.bindingGroup.unbind();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void showModalPopupPanel(ModalPopupPanel popupPanel) {
        Component focusOwner = this.getFocusOwner();
        if (focusOwner != null) {
            this.focusedComponents.push(focusOwner);
        }
        popupPanel.setBounds(this.getContentPane().getBounds());
        this.getLayeredPane().add(popupPanel, this.popupIndex++, 0);
    }

    @Override
    public void hideModalPopupPanel(ModalPopupPanel popupPanel) {
        this.getLayeredPane().remove(popupPanel);
        --this.popupIndex;
        this.validate();
        this.repaint();
        if (!this.focusedComponents.isEmpty()) {
            Component comp = this.focusedComponents.pop();
            comp.requestFocusInWindow();
        }
    }
}

