/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.actions.TmmAction;

public class DeleteTrashAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTrashAction.class);

    public DeleteTrashAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.deletetrash"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.deletetrash.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path file;
        for (String ds : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
            file = Paths.get(ds, ".deletedByTMM");
            try {
                Utils.deleteDirectoryRecursive(file);
            }
            catch (Exception ex) {
                LOGGER.error("Could not delete folder '{}' - '{}'", (Object)file.toAbsolutePath(), (Object)ex.getMessage());
            }
        }
        for (String ds : TvShowModuleManager.getInstance().getSettings().getTvShowDataSource()) {
            file = Paths.get(ds, ".deletedByTMM");
            try {
                Utils.deleteDirectoryRecursive(file);
            }
            catch (Exception ex) {
                LOGGER.error("Could not delete folder '{}' - '{}'", (Object)file.toAbsolutePath(), (Object)ex.getMessage());
            }
        }
    }
}

