/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaArtwork {
    public static final int MAX_IMAGE_SIZE_ORDER = 32;
    private final String providerId;
    private final MediaArtworkType type;
    private String imdbId;
    private int tmdbId;
    private int season = -1;
    private String previewUrl = "";
    private String originalUrl = "";
    private String language = "";
    private int likes = 0;
    private boolean animated = false;
    private final List<ImageSizeAndUrl> imageSizes = new ArrayList<ImageSizeAndUrl>();

    public MediaArtwork(String providerId, MediaArtworkType type) {
        this.providerId = providerId;
        this.type = type;
    }

    public MediaArtwork(MediaArtwork oldArtwork, MediaArtworkType type) {
        this.imdbId = oldArtwork.getImdbId();
        this.tmdbId = oldArtwork.getTmdbId();
        this.season = oldArtwork.getSeason();
        this.previewUrl = oldArtwork.getPreviewUrl();
        this.originalUrl = oldArtwork.getOriginalUrl();
        this.language = oldArtwork.getLanguage();
        this.providerId = oldArtwork.getProviderId();
        this.likes = oldArtwork.getLikes();
        for (ImageSizeAndUrl oldImageSizeAndUrl : oldArtwork.getImageSizes()) {
            this.imageSizes.add(new ImageSizeAndUrl(oldImageSizeAndUrl.width, oldImageSizeAndUrl.height, oldImageSizeAndUrl.url));
        }
        this.type = type;
    }

    public static int getSizeOrder(MediaArtworkType type, int width) {
        return switch (type) {
            case MediaArtworkType.POSTER -> PosterSizes.getSizeOrder(width);
            case MediaArtworkType.BACKGROUND -> FanartSizes.getSizeOrder(width);
            case MediaArtworkType.THUMB -> ThumbSizes.getSizeOrder(width);
            default -> 0;
        };
    }

    public String getPreviewUrl() {
        if (StringUtils.isBlank((CharSequence)this.previewUrl)) {
            return this.originalUrl;
        }
        return this.previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public MediaArtworkType getType() {
        return this.type;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = StrgUtils.getNonNullString(language);
    }

    public int getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(int tmdbId) {
        this.tmdbId = tmdbId;
    }

    public String getImdbId() {
        return this.imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = StrgUtils.getNonNullString(imdbId);
    }

    public void addImageSize(int width, int height, String url, int sizeOrder) {
        ImageSizeAndUrl imageSizeAndUrl = new ImageSizeAndUrl(width, height, url, sizeOrder);
        if (!this.imageSizes.contains(imageSizeAndUrl)) {
            this.imageSizes.add(imageSizeAndUrl);
        }
    }

    public List<ImageSizeAndUrl> getImageSizes() {
        ArrayList<ImageSizeAndUrl> descImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
        descImageSizes.sort(Collections.reverseOrder());
        return descImageSizes;
    }

    public int getMatchingScoreAccordingPreferences(int wantedSize, List<MediaLanguages> preferredLanguages, boolean preferFanartWoText) {
        int score = 0;
        boolean languageMatched = false;
        boolean sizeMatched = false;
        if (!this.language.isEmpty()) {
            try {
                MediaLanguages maLang = MediaLanguages.valueOf(this.language);
                if (preferredLanguages.contains((Object)maLang)) {
                    languageMatched = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (preferredLanguages.contains((Object)MediaLanguages.none) || preferFanartWoText && this.type == MediaArtworkType.BACKGROUND) {
            languageMatched = true;
        }
        if (wantedSize > 0) {
            for (ImageSizeAndUrl imageSizeAndUrl : this.imageSizes) {
                if (imageSizeAndUrl.getSizeOrder() != wantedSize) continue;
                sizeMatched = true;
            }
        }
        if ("ffmpeg".equals(this.providerId)) {
            if (sizeMatched) {
                score += 30;
            }
        } else if (languageMatched && sizeMatched) {
            score += 90;
        } else if (languageMatched) {
            score += 50;
        } else if (sizeMatched) {
            score += 40;
        }
        if (this.isAnimated()) {
            score += 5;
        }
        return score;
    }

    public ImageSizeAndUrl getSmallestArtwork() {
        if (!this.imageSizes.isEmpty()) {
            ArrayList<ImageSizeAndUrl> ascImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
            Collections.sort(ascImageSizes);
            ImageSizeAndUrl smallestImage = (ImageSizeAndUrl)ascImageSizes.get(0);
            if (smallestImage != null) {
                return smallestImage;
            }
        }
        return null;
    }

    public ImageSizeAndUrl getBiggestArtwork() {
        if (!this.imageSizes.isEmpty()) {
            ArrayList<ImageSizeAndUrl> descImageSizes = new ArrayList<ImageSizeAndUrl>(this.imageSizes);
            descImageSizes.sort(Collections.reverseOrder());
            ImageSizeAndUrl biggestImage = (ImageSizeAndUrl)descImageSizes.get(0);
            if (biggestImage != null) {
                return biggestImage;
            }
        }
        return null;
    }

    public int getLikes() {
        return this.likes;
    }

    public void setLikes(int likes) {
        this.likes = likes;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public int getSeason() {
        return this.season;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static List<Integer> sortSizeOrderByPreference(int preferred) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int newOrder = 32; newOrder >= 1; newOrder /= 2) {
            indices.add(newOrder);
        }
        indices.add(0);
        int indexP = indices.indexOf(preferred);
        return indices.stream().sorted((a, b) -> {
            int distB;
            if (a == preferred) {
                return -1;
            }
            if (b == preferred) {
                return 1;
            }
            if (a == 0 || b == 0) {
                return 1;
            }
            int indexA = indices.indexOf(a);
            int indexB = indices.indexOf(b);
            int distA = Math.abs(indexA - indexP);
            if (distA != (distB = Math.abs(indexB - indexP))) {
                return Integer.compare(distA, distB);
            }
            return Integer.compare(b, a);
        }).toList();
    }

    public static enum MediaArtworkType {
        BACKGROUND,
        BANNER,
        POSTER,
        ACTOR,
        SEASON_POSTER,
        SEASON_FANART,
        SEASON_BANNER,
        SEASON_THUMB,
        THUMB,
        CLEARART,
        KEYART,
        CHARACTERART,
        DISC,
        LOGO,
        CLEARLOGO,
        ALL;

    }

    public static class ImageSizeAndUrl
    implements Comparable<ImageSizeAndUrl> {
        private final int width;
        private final int height;
        private final int sizeOrder;
        private final String url;

        public ImageSizeAndUrl(int width, int height, String url) {
            this(width, height, url, 0);
        }

        public ImageSizeAndUrl(int width, int height, String url, int sizeOrder) {
            this.width = width;
            this.height = height;
            this.sizeOrder = sizeOrder;
            this.url = StrgUtils.getNonNullString(url);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getSizeOrder() {
            return this.sizeOrder;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(ImageSizeAndUrl obj) {
            if (obj == null) {
                return 1;
            }
            return this.width * this.height - obj.width * obj.height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageSizeAndUrl that = (ImageSizeAndUrl)o;
            return this.width == that.width && this.height == that.height && this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height, this.url);
        }

        public String toString() {
            return this.width + "x" + this.height;
        }
    }

    public static enum PosterSizes {
        XLARGE(TmmResourceBundle.getString("Settings.image.xlarge"), 2000, 3000, 16),
        LARGE(TmmResourceBundle.getString("Settings.image.large"), 1000, 1500, 8),
        BIG(TmmResourceBundle.getString("Settings.image.big"), 500, 750, 4),
        MEDIUM(TmmResourceBundle.getString("Settings.image.medium"), 342, 513, 2),
        SMALL(TmmResourceBundle.getString("Settings.image.small"), 185, 278, 1);

        private final String text;
        private final int width;
        private final int height;
        private final int order;

        private PosterSizes(String text, int width, int height, int order) {
            this.text = text + ": ~" + width + "x" + height + "px";
            this.width = width;
            this.height = height;
            this.order = order;
        }

        public String toString() {
            return this.text;
        }

        public int getOrder() {
            return this.order;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static int getSizeOrder(int width) {
            for (PosterSizes entry : PosterSizes.values()) {
                if (width < entry.width) continue;
                return entry.order;
            }
            return 0;
        }
    }

    public static enum FanartSizes {
        XLARGE(TmmResourceBundle.getString("Settings.image.xlarge"), 3840, 2160, 16),
        LARGE(TmmResourceBundle.getString("Settings.image.large"), 1920, 1080, 8),
        MEDIUM(TmmResourceBundle.getString("Settings.image.medium"), 1280, 720, 2),
        SMALL(TmmResourceBundle.getString("Settings.image.small"), 300, 168, 1);

        private final String text;
        private final int width;
        private final int height;
        private final int order;

        private FanartSizes(String text, int width, int height, int order) {
            this.text = text + ": ~" + width + "x" + height + "px";
            this.width = width;
            this.height = height;
            this.order = order;
        }

        public String toString() {
            return this.text;
        }

        public int getOrder() {
            return this.order;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static int getSizeOrder(int width) {
            for (FanartSizes entry : FanartSizes.values()) {
                if (width < entry.width) continue;
                return entry.order;
            }
            return 0;
        }
    }

    public static enum ThumbSizes {
        XLARGE(TmmResourceBundle.getString("Settings.image.xlarge"), 3840, 2160, 16),
        LARGE(TmmResourceBundle.getString("Settings.image.large"), 1920, 1080, 8),
        BIG(TmmResourceBundle.getString("Settings.image.big"), 1000, 562, 4),
        MEDIUM(TmmResourceBundle.getString("Settings.image.medium"), 640, 360, 2),
        SMALL(TmmResourceBundle.getString("Settings.image.small"), 300, 168, 1);

        private final String text;
        private final int width;
        private final int height;
        private final int order;

        private ThumbSizes(String text, int width, int height, int order) {
            this.text = text + ": ~" + width + "x" + height + "px";
            this.width = width;
            this.height = height;
            this.order = order;
        }

        public String toString() {
            return this.text;
        }

        public int getOrder() {
            return this.order;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static int getSizeOrder(int width) {
            for (ThumbSizes entry : ThumbSizes.values()) {
                if (width < entry.width) continue;
                return entry.order;
            }
            return 0;
        }
    }
}

