/*
 * Decompiled with CFR 0.152.
 */
package io.github.jacksonbrienen.jwfd;

import io.github.jacksonbrienen.jwfd.FileExtension;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

final class JFileDialog {
    private JFileDialog() {
    }

    static String showOpenDialog(Frame frame, String title, String path, FileExtension ... filters) {
        MutableAcceptanceFileChooser chooser = new MutableAcceptanceFileChooser();
        chooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
        if (title != null) {
            chooser.setDialogTitle(title);
        } else {
            chooser.setDialogTitle("Open");
        }
        if (path != null) {
            chooser.setCurrentDirectory(new File(path));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        chooser.setFilters(filters);
        if (chooser.showOpenDialog(frame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static String[] showMultiDialog(Frame frame, String title, String path, FileExtension ... filters) {
        MutableAcceptanceFileChooser chooser = new MutableAcceptanceFileChooser();
        chooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
        if (title != null) {
            chooser.setDialogTitle(title);
        } else {
            chooser.setDialogTitle("Open");
        }
        if (path != null) {
            chooser.setCurrentDirectory(new File(path));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        chooser.setFilters(filters);
        if (chooser.showMultiDialog(frame) == 0) {
            return (String[])Arrays.stream(chooser.getSelectedFiles()).map(File::getAbsolutePath).toArray(String[]::new);
        }
        return null;
    }

    static String showSaveDialog(Frame frame, String title, String path, FileExtension ... filters) {
        MutableAcceptanceFileChooser chooser = new MutableAcceptanceFileChooser();
        chooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
        if (title != null) {
            chooser.setDialogTitle(title);
        } else {
            chooser.setDialogTitle("Save As");
        }
        if (path != null) {
            chooser.setCurrentDirectory(new File(path));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        chooser.setFilters(filters);
        if (chooser.showSaveDialog(frame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static String showDirDialog(Frame frame, String title, String path) {
        MutableAcceptanceFileChooser chooser = new MutableAcceptanceFileChooser();
        chooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
        if (title != null) {
            chooser.setDialogTitle(title);
        } else {
            chooser.setDialogTitle("Open Folder");
        }
        if (path != null) {
            chooser.setCurrentDirectory(new File(path));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (chooser.showDirDialog(frame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private static final class MutableAcceptanceFileChooser
    extends JFileChooser {
        private final SelectionApprover openFileApprover = new SelectionApprover(() -> super.approveSelection()){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.exists()) {
                    JOptionPane.showMessageDialog(this, String.format("%s\nThe file name is not valid.", f.getName()), this.getDialogTitle(), 2);
                } else if (!Files.isReadable(f.toPath())) {
                    JOptionPane.showMessageDialog(this, String.format("%s\nThis file is in use.\nEnter a new name or close the file that's open in another program.", f.getName()), this.getDialogTitle(), 2);
                } else {
                    this.approve();
                }
            }
        };
        private final SelectionApprover saveFileApprover = new SelectionApprover(() -> super.approveSelection()){

            @Override
            public void approveSelection() {
                String name = this.getSelectedFile().getAbsolutePath();
                if (this.getFileFilter() != FileExtension.ALL) {
                    String[] extensions = ((FileExtension)this.getFileFilter()).getExtensions();
                    boolean addExtension = true;
                    for (String s : extensions) {
                        if (!name.endsWith(s)) continue;
                        addExtension = false;
                        break;
                    }
                    if (addExtension) {
                        name = name + extensions[0];
                        this.setSelectedFile(new File(name));
                    }
                }
                if (this.getSelectedFile().exists()) {
                    if (JOptionPane.showConfirmDialog(this, String.format("%s already exists.\nDo you want to replace it?", name), "Confirm Save As", 0, 2) == 0) {
                        if (!Files.isWritable(this.getSelectedFile().toPath())) {
                            JOptionPane.showMessageDialog(this, String.format("%s\nThis file is in use.\nEnter a new name or close the file that's open in another program.", this.getSelectedFile().getName()), this.getDialogTitle(), 2);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                try {
                    if (this.getSelectedFile().createNewFile()) {
                        this.getSelectedFile().delete();
                    }
                    this.approve();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, String.format("%s\nYou don't have permission to save in this location.\nContact the administrator to obtain permission.", this.getSelectedFile().getAbsolutePath()), this.getDialogTitle(), 2);
                }
            }
        };
        private final SelectionApprover folderApprover = new SelectionApprover(() -> super.approveSelection()){

            @Override
            public void approveSelection() {
                if (!this.getSelectedFile().exists()) {
                    if (JOptionPane.showConfirmDialog(this, String.format("The folder %s does not exist. Do you want to create it?", this.getSelectedFile().getName()), "Create Folder", 0, 2) == 1) {
                        return;
                    }
                    if (!this.getSelectedFile().mkdirs()) {
                        JOptionPane.showMessageDialog(this, String.format("Error creating folder:\n%s\n\nMake sure you have permissions to create folders in this directory.", this.getSelectedFile().getAbsolutePath()), "Could not create Folder", 0);
                        return;
                    }
                }
                this.approve();
            }
        };
        private final SelectionApprover multiApprover = new SelectionApprover(() -> super.approveSelection()){

            @Override
            public void approveSelection() {
                File[] files = this.getSelectedFiles();
                boolean exist = true;
                for (File f : files) {
                    if (f.exists()) continue;
                    exist = false;
                    break;
                }
                if (!exist) {
                    JOptionPane.showMessageDialog(this, "One or more of the selected files don't exist.", "File Error", 0);
                    return;
                }
                boolean readable = true;
                for (File f : files) {
                    if (Files.isReadable(f.toPath())) continue;
                    readable = false;
                    break;
                }
                if (!readable) {
                    JOptionPane.showMessageDialog(this, "One or more of the select files are\nbeing used by another program.", "File Error", 0);
                    return;
                }
                this.approve();
            }
        };
        private SelectionApprover approver;

        public MutableAcceptanceFileChooser() {
            super(".");
        }

        @Override
        public void approveSelection() {
            if (this.approver != null) {
                this.approver.approveSelection();
            } else {
                super.approveSelection();
            }
        }

        @Override
        public int showOpenDialog(Component parent) {
            this.approver = this.openFileApprover;
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            return super.showOpenDialog(parent);
        }

        public int showMultiDialog(Component parent) {
            this.approver = this.multiApprover;
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(true);
            return super.showOpenDialog(parent);
        }

        public int showDirDialog(Component parent) {
            this.approver = this.folderApprover;
            this.setFileSelectionMode(1);
            this.setMultiSelectionEnabled(false);
            this.resetChoosableFileFilters();
            return super.showOpenDialog(parent);
        }

        @Override
        public int showSaveDialog(Component parent) {
            this.approver = this.saveFileApprover;
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            return super.showSaveDialog(parent);
        }

        public void setFilters(FileExtension ... filters) {
            this.resetChoosableFileFilters();
            this.removeChoosableFileFilter(this.getFileFilter());
            if (filters != null && filters.length > 0) {
                for (FileExtension f : filters) {
                    this.addChoosableFileFilter(f);
                }
            } else {
                this.addChoosableFileFilter(FileExtension.ALL);
            }
        }
    }

    private static abstract class SelectionApprover {
        private final Runnable approve;

        public SelectionApprover(Runnable approve) {
            this.approve = approve;
        }

        public abstract void approveSelection();

        public final void approve() {
            this.approve.run();
        }
    }
}

